package net.linksfield.cube.partnersdk.json;

import lombok.Getter;
import net.linksfield.cube.partnersdk.utils.ClassUtils;

/**
 * @ClassName MessageConverter
 * @Description JSON消息转换管理 上层管理器 由此加载不同的实现
 * @Author James.hu
 * @Date 2023/3/14
 **/
public class MessageConverter {
    private static final boolean jackson2Present;

    @Getter
    private final JsonSerializer jsonSerializer;

    static {
        // 检测是否存在jackson类
        ClassLoader classLoader = MessageConverter.class.getClassLoader();
        jackson2Present = ClassUtils.isPresent("com.fasterxml.jackson.databind.ObjectMapper", classLoader) &&
                ClassUtils.isPresent("com.fasterxml.jackson.core.JsonGenerator", classLoader);
    }

    public MessageConverter() {
        // 根据类检测结果, 决定采用的json序列化实现
        if (jackson2Present) {
            jsonSerializer = new JacksonJsonSerializer();
        } else {
            throw new IllegalArgumentException("Unable to determine valid json library");
        }
    }
}
