package net.linksfield.cube.partnersdk.json;

import java.util.Map;

/**
 * @ClassName JsonSerializer
 * @Description Json 序列化接口
 * @Author James.hu
 * @Date 2023/3/14
 **/
public interface JsonSerializer {
    /**
     * 转换为Key字段排序的Json
     * @param value 转换对象
     * @return
     */
    String toLinkedJson(Object value);

    /**
     * 转换为标准json
     * @param value 转换对象
     * @return
     */
    String toJson(Object value);

    /**
     * 将对象转换为Map
     * @param source 转换对象
     * @return
     */
    Map<String, Object> convertMap(Object source);

    /**
     * 解析Json到对象
     * @param source json原文
     * @param clazz 目标对象
     * @return
     */
    <T> T parse(byte[] source, Class<T> clazz);
}
