package net.linksfield.cube.partnersdk.event.events;

import lombok.Getter;
import net.linksfield.cube.partnersdk.event.AbstractEvent;
import net.linksfield.cube.partnersdk.event.EventType;

/**
 * @ClassName SdkInitEvent
 * @Description SDK 初始化后事件
 * @Author James.hu
 * @Date 2023/3/17
 **/
@Getter
public class SdkInitEvent extends AbstractEvent {
    /** AccessKey */
    private String accessKey;

    /** Private Key */
    private String privateKey;

    public SdkInitEvent(String accessKey, String privateKey) {
        super(EventType.SdkInit);
        this.accessKey = accessKey;
        this.privateKey = privateKey;
    }
}
