package net.linksfield.cube.partnersdk.event;

import lombok.extern.slf4j.Slf4j;

/**
 * @ClassName Events
 * @Description 事件管理 统一接口
 * @Author James.hu
 * @Date 2023/3/16
 **/
@Slf4j
public class Events {
    /** 单例管理 */
    private static Events instance = new Events();
    private Events() {
        this.dispatcher = new AsyncDispatcher();
        registerShutdownHook();
    }


    /** 事件分发器 */
    private AsyncDispatcher dispatcher;

    /**
     * Register an event handler
     * @param eventType Event type
     * @param eventHandler Event handler implement
     */
    public static void register(EventType eventType, EventHandler eventHandler) {
        Events.instance.dispatcher.register(eventType, eventHandler);
    }

    /**
     * Dispatch an event
     * Called by the SDK
     * @param event Event
     */
    public static void dispatch(Event event) {
        Events.instance.dispatcher.dispatch(event);
    }

    /**
     * Start the event publish
     * <p>The event is published only after the start() method is called</p>
     */
    public static void start() {
        Events.instance.dispatcher.serviceStart();
    }

    public static void stop() {
        Events.instance.dispatcher.serviceStop();
    }

    /** 注册关闭钩子 */
    private void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread() {
            @Override
            public void run() {
                log.info("shutdown events dispatcher, release resources");
                dispatcher.serviceStop();
            }
        });
    }

}
