package net.linksfield.cube.partnersdk.event;

/**
 * Parent class of all the events. All events extend this class.
 * 所有事件的父类：包含类型和时间戳
 *
 * @author
 */
public abstract class AbstractEvent implements Event {

    private final EventType type;
    private final long timestamp;

    private Object source;

    public AbstractEvent(EventType eventType) {
        this(eventType, null, -1L);
    }

    public AbstractEvent(EventType eventType, Object source) {
        this(eventType, source, -1L);
    }

    public AbstractEvent(EventType eventType, Object source, long timestamp) {
        this.type = eventType;
        this.source = source;
        this.timestamp = timestamp;
    }

    @Override
    public Object getSource() {
        return source;
    }

    @Override
    public long getTimestamp() {
        return timestamp;
    }

    @Override
    public EventType getType() {
        return type;
    }

    @Override
    public String toString() {
        return "EventType: " + getType();
    }

}
