package net.linksfield.cube.partnersdk.domain;

import lombok.extern.slf4j.Slf4j;
import net.linksfield.cube.partnersdk.rest.*;
import net.linksfield.cube.partnersdk.sdk.ServicesContainer;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;

/**
 * @ClassName SignatureBuilderV2
 * @Description 用于构建签名的帮助类
 * @Author James.hu
 * @Date 2023/3/15
 **/
@Slf4j
public class SignatureBuilderV2 extends SignatureBuilder {

    public SignatureBuilderV2(BaseRequest domain, ServicesContainer servicesContainer) {
        super(domain, servicesContainer);
    }

    @Override
    public void signature() {
        throw new IllegalStateException("not implements");
    }

    public void signature(HttpRequestBuilder httpRequestBuilder) {
        log.trace("domain:[{}] set all global parameters, build signature V2", domain.getClass().getName());
        createMapToSignWithGlobalParameters()
                .addUrlSignatureParameters(mapToSign, httpRequestBuilder)
                .addSignatureParameters(mapToSign, httpRequestBuilder)
                .buildStringToSign(servicesContainer.getMessageConverter())
                .buildSignature(servicesContainer.getCommonVariables());
    }

    protected SignatureBuilderV2 addUrlSignatureParameters(Map<String, Object> mapToSign, HttpRequestBuilder httpRequestBuilder) {
        URI uri = URI.create(httpRequestBuilder.getRequestWrapper().getUrl());
        mapToSign.put("x-sign-uri", uri.getPath());
        return this;
    }

    private SignatureBuilderV2 addSignatureParameters(Map<String, Object> mapToSign, HttpRequestBuilder httpRequestBuilder) {
        HttpRequest httpRequest = httpRequestBuilder.getRequestWrapper();
        if (HttpMethod.GET.equals(httpRequest.getMethod())) {
            httpRequest.getQueryParams().forEach((key, value) -> mapToSign.put(key, value));
        } else {
            mapToSign.putAll(httpRequestBuilder.getBodyMap());
        }
        return this;
    }

    public SignatureBuilderV2 createMapToSignWithGlobalParameters() {
        Map<String, Object> map = new HashMap<>(5);
        map.put("timestamp", domain.getTimestamp());
        map.put("nonce", Integer.toString(domain.getNonce()));

        this.mapToSign = map;
        return this;
    }

}
