package net.linksfield.cube.partnersdk.domain;

import lombok.extern.slf4j.Slf4j;
import net.linksfield.cube.partnersdk.sdk.ServicesContainer;

import java.util.HashMap;
import java.util.Map;

/**
 * @ClassName SignatureBuilderV1
 * @Description 用于构建签名的帮助类
 * @Author James.hu
 * @Date 2023/3/15
 **/
@Slf4j
public class SignatureBuilderV1 extends SignatureBuilder {

    public SignatureBuilderV1(BaseRequest domain, ServicesContainer servicesContainer) {
        super(domain, servicesContainer);
    }

    public void signature() {
        log.trace("domain:[{}] set all global parameters, build signature", domain.getClass().getName());
        createMapToSignWithGlobalParameters()
                .addUrlSignatureParameters(mapToSign)
                .buildStringToSign(servicesContainer.getMessageConverter())
                .buildSignature(servicesContainer.getCommonVariables());
    }

    public SignatureBuilder createMapToSignWithGlobalParameters() {
        Map<String, Object> map = new HashMap<>(5);
        map.put("timestamp", domain.getTimestamp());
        map.put("nonce", domain.getNonce());

        this.mapToSign = map;
        return this;
    }

}
