package net.linksfield.cube.partnersdk.domain;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import net.linksfield.cube.partnersdk.json.MessageConverter;
import net.linksfield.cube.partnersdk.sdk.ServicesContainer;
import net.linksfield.cube.partnersdk.utils.SignatureUtils;

import java.util.Map;

/**
 * @ClassName RequestBuilder
 * @Description 请求参数构造器
 * @Author James.hu
 * @Date 2023/3/15
 **/
@Slf4j
@Data
public abstract class SignatureBuilder {
    /** 用户参数 */
    protected BaseRequest domain;

    /** 业务逻辑支持封装 */
    protected ServicesContainer servicesContainer;

    /** 等待签名的数据整合的Map */
    protected Map<String, Object> mapToSign;

    /** 等待签名的字符串 */
    protected String stringToSign;

    /** 产生的签名 */
    protected String signature;

    public SignatureBuilder(BaseRequest domain, ServicesContainer servicesContainer) {
        this.domain = domain;
        this.servicesContainer = servicesContainer;
    }

    /** 生成签名 */
    public abstract void signature();

    /** 由子类实现 将参与签名的公共参数构建为Map */
    protected abstract SignatureBuilder createMapToSignWithGlobalParameters();

    /** 将参与签名的Url参数添加到签名结构 回调给Domain来实现 */
    protected SignatureBuilder addUrlSignatureParameters(Map<String, Object> mapToSign) {
        domain.addUrlSignatureParameters(mapToSign);
        return this;
    }

    /** 构造签名字符串 */
    protected SignatureBuilder buildStringToSign(MessageConverter messageConverter) {
        this.stringToSign = messageConverter.getJsonSerializer().toLinkedJson(this.mapToSign);
        return this;
    }

    /** 进行签名 并向Authorization数据赋值*/
    protected SignatureBuilder buildSignature(CommonVariables commonVariables) {
        try {
            this.signature = SignatureUtils.sign(stringToSign, commonVariables.getPrivateKey());
            return this;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String build() {
        return signature;
    }
}
