package net.linksfield.cube.partnersdk.configuration;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/**
 * @ClassName EndpointModuleInvocationHandler
 * @Description API端点配置读取逻辑 动态代理了读取接口
 * @Author James.hu
 * @Date 2023/3/15
 **/
public class EndpointModuleInvocationHandler implements InvocationHandler {

    /** 从配置文件加载的API Host配置*/
    private String host;
    private Map<String, String> properties;

    public EndpointModuleInvocationHandler(String host) {
        this.host = host;
        this.properties = new HashMap<>();
    }

    public void setProperties(String key, String value) {
        this.properties.put(key, value);
    }

    /**
     * 动态代理了配置读取接口
     * 从配置文件读取的项目被缓存在本身的Map中
     * 返回数据时自动将Host参数拼接在前
     * @return 完整Url请求地址(参数掩码将被转换)
     * @throws Throwable
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        // 接口名称必须与配置文件中的定义相同
        // 获取对应的值
        String uri = properties.get(method.getName().toString());
        String urlPattern = host + uri;
        return formatUrl(urlPattern, args);
    }

    /** 使用接口参数列表来转换Url上的参数掩码 */
    private String formatUrl(String urlPattern, Object[] args) {
        return String.format(urlPattern, args);
    }
}
