/*
 * Decompiled with CFR 0.152.
 */
package net.lightoze.jooq.postgresql.notify;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.function.BooleanSupplier;
import org.postgresql.PGConnection;
import org.postgresql.PGNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NotificationListener {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Configuration configuration = new Configuration();

    protected abstract Connection getConnection() throws SQLException;

    protected void closeConnection(Connection connection) throws SQLException {
        connection.close();
    }

    protected abstract void receiveNotification(PGNotification var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(BooleanSupplier runningSupplier) {
        while (runningSupplier.getAsBoolean()) {
            Connection conn;
            try {
                conn = this.getConnection();
            }
            catch (Throwable e) {
                this.log.error("Could not get a connection", e);
                try {
                    Thread.sleep(this.configuration.getRetryDelayMillis());
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try {
                conn.setAutoCommit(true);
                for (String channel : this.configuration.getChannels()) {
                    try (Statement stmt = conn.createStatement();){
                        stmt.execute("LISTEN " + channel);
                    }
                }
                while (runningSupplier.getAsBoolean()) {
                    try (Statement stmt = conn.createStatement();){
                        stmt.setQueryTimeout(this.configuration.getFetchTimeoutMillis());
                        stmt.execute("SELECT 1");
                    }
                    PGNotification[] notifications = conn.unwrap(PGConnection.class).getNotifications(this.configuration.getFetchTimeoutMillis());
                    if (notifications == null) continue;
                    for (PGNotification notification : notifications) {
                        try {
                            this.receiveNotification(notification);
                        }
                        catch (Throwable e) {
                            this.log.error("Error processing notification {} ({}) from {}", new Object[]{notification.getName(), notification.getParameter(), notification.getPID(), e});
                        }
                    }
                }
            }
            catch (Throwable e) {
                this.log.error("Error while listening for notifications", e);
                try {
                    Thread.sleep(this.configuration.getRetryDelayMillis());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                try {
                    this.closeConnection(conn);
                }
                catch (Throwable e) {
                    this.log.warn("Error closing connection", e);
                }
            }
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public static class Configuration {
        private String[] channels = new String[0];
        private long retryDelayMillis = 10000L;
        private int validationTimeoutMillis = 3000;
        private int fetchTimeoutMillis = 1000;

        public void setChannels(String ... channels) {
            this.channels = channels;
        }

        public String[] getChannels() {
            return this.channels;
        }

        public long getRetryDelayMillis() {
            return this.retryDelayMillis;
        }

        public int getValidationTimeoutMillis() {
            return this.validationTimeoutMillis;
        }

        public int getFetchTimeoutMillis() {
            return this.fetchTimeoutMillis;
        }

        public void setRetryDelayMillis(long retryDelayMillis) {
            this.retryDelayMillis = retryDelayMillis;
        }

        public void setValidationTimeoutMillis(int validationTimeoutMillis) {
            this.validationTimeoutMillis = validationTimeoutMillis;
        }

        public void setFetchTimeoutMillis(int fetchTimeoutMillis) {
            this.fetchTimeoutMillis = fetchTimeoutMillis;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Configuration)) {
                return false;
            }
            Configuration other = (Configuration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getChannels(), other.getChannels())) {
                return false;
            }
            if (this.getRetryDelayMillis() != other.getRetryDelayMillis()) {
                return false;
            }
            if (this.getValidationTimeoutMillis() != other.getValidationTimeoutMillis()) {
                return false;
            }
            return this.getFetchTimeoutMillis() == other.getFetchTimeoutMillis();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Configuration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getChannels());
            long $retryDelayMillis = this.getRetryDelayMillis();
            result = result * 59 + (int)($retryDelayMillis >>> 32 ^ $retryDelayMillis);
            result = result * 59 + this.getValidationTimeoutMillis();
            result = result * 59 + this.getFetchTimeoutMillis();
            return result;
        }

        public String toString() {
            return "NotificationListener.Configuration(channels=" + Arrays.deepToString(this.getChannels()) + ", retryDelayMillis=" + this.getRetryDelayMillis() + ", validationTimeoutMillis=" + this.getValidationTimeoutMillis() + ", fetchTimeoutMillis=" + this.getFetchTimeoutMillis() + ")";
        }
    }
}

