/*
 * Decompiled with CFR 0.152.
 */
package net.lightoze.jooq.postgresql.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.lightoze.jooq.postgresql.json.AbstractJacksonConverter;
import org.jooq.JSONB;

public class JacksonJsonbListConverter<T>
extends AbstractJacksonConverter<JSONB[], List<T>, T> {
    public JacksonJsonbListConverter() {
    }

    public JacksonJsonbListConverter(JavaType userType, JavaType elementType) {
        super(userType, elementType);
    }

    public List<T> from(JSONB[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(array.length);
        for (JSONB json : array) {
            if (json == null || json.data().equals("null")) {
                list.add(this.getNull());
                continue;
            }
            try {
                list.add(this.getObjectReader().readValue(json.data()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return list;
    }

    public JSONB[] to(List<T> list) {
        if (list == null) {
            return null;
        }
        JSONB[] array = new JSONB[list.size()];
        Iterator<T> it = list.iterator();
        for (int i = 0; i < array.length; ++i) {
            T value = it.next();
            if (value == null || this.isNull(value)) {
                array[i] = null;
                continue;
            }
            try {
                array[i] = JSONB.valueOf((String)this.getObjectWriter().writeValueAsString(value));
                continue;
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        return array;
    }

    public Class<JSONB[]> fromType() {
        return JSONB[].class;
    }
}

