/*
 * Decompiled with CFR 0.152.
 */
package net.lightoze.jooq.postgresql.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.lightoze.jooq.postgresql.json.AbstractJacksonConverter;
import org.jooq.JSON;

public class JacksonJsonListConverter<T>
extends AbstractJacksonConverter<JSON[], List<T>, T> {
    public JacksonJsonListConverter() {
    }

    public JacksonJsonListConverter(JavaType userType, JavaType elementType) {
        super(userType, elementType);
    }

    public List<T> from(JSON[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(array.length);
        for (JSON json : array) {
            if (json == null || json.data().equals("null")) {
                list.add(this.getNull());
                continue;
            }
            try {
                list.add(this.getObjectReader().readValue(json.data()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return list;
    }

    public JSON[] to(List<T> list) {
        if (list == null) {
            return null;
        }
        JSON[] array = new JSON[list.size()];
        Iterator<T> it = list.iterator();
        for (int i = 0; i < array.length; ++i) {
            T value = it.next();
            if (value == null || this.isNull(value)) {
                array[i] = null;
                continue;
            }
            try {
                array[i] = JSON.valueOf((String)this.getObjectWriter().writeValueAsString(value));
                continue;
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        return array;
    }

    public Class<JSON[]> fromType() {
        return JSON[].class;
    }
}

