/*
 * Decompiled with CFR 0.152.
 */
package net.lightoze.jooq.postgresql.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import java.io.IOException;
import net.lightoze.jooq.postgresql.json.AbstractJacksonConverter;
import org.jooq.JSON;

public class JacksonJsonConverter<T>
extends AbstractJacksonConverter<JSON, T, T> {
    public JacksonJsonConverter() {
    }

    public JacksonJsonConverter(JavaType userType, JavaType elementType) {
        super(userType, elementType);
    }

    public T from(JSON json) {
        if (json == null || json.data().equals("null")) {
            return (T)this.getNull();
        }
        try {
            return (T)this.getObjectReader().readValue(json.data());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JSON to(T value) {
        if (value == null || this.isNull(value)) {
            return null;
        }
        try {
            return JSON.valueOf((String)this.getObjectWriter().writeValueAsString(value));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<JSON> fromType() {
        return JSON.class;
    }
}

