/*
 * Decompiled with CFR 0.152.
 */
package net.lightoze.jooq.postgresql.json;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.concurrent.atomic.AtomicReference;
import org.jooq.Converter;

public abstract class AbstractJacksonConverter<O, T, E>
implements Converter<O, T> {
    private final AtomicReference<Object> objectWriter = new AtomicReference();
    private final AtomicReference<Object> objectReader = new AtomicReference();
    private final JavaType userType;
    private final JavaType elementType;

    public AbstractJacksonConverter() {
        this.userType = this.resolveType(1);
        this.elementType = this.resolveType(2);
    }

    public AbstractJacksonConverter(JavaType userType, JavaType elementType) {
        this.userType = userType;
        this.elementType = elementType;
    }

    protected ObjectMapper getMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.findAndRegisterModules();
        return mapper;
    }

    protected E getNull() {
        return null;
    }

    protected boolean isNull(E value) {
        return false;
    }

    protected ObjectWriter createObjectWriter() {
        return this.getMapper().writerFor(this.elementType);
    }

    protected ObjectReader createObjectReader() {
        return this.getMapper().readerFor(this.elementType);
    }

    public Class<T> toType() {
        return this.userType.getRawClass();
    }

    private JavaType resolveType(int index) {
        JavaType selfType = this.getMapper().constructType(this.getClass());
        JavaType[] typeParameters = selfType.findTypeParameters(AbstractJacksonConverter.class);
        if (typeParameters.length == 3) {
            return typeParameters[index];
        }
        throw new UnsupportedOperationException("Could not resolve value type for converter " + this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectWriter getObjectWriter() {
        Object value = this.objectWriter.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.objectWriter;
            synchronized (atomicReference) {
                value = this.objectWriter.get();
                if (value == null) {
                    ObjectWriter actualValue = this.createObjectWriter();
                    value = actualValue == null ? this.objectWriter : actualValue;
                    this.objectWriter.set(value);
                }
            }
        }
        return (ObjectWriter)(value == this.objectWriter ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectReader getObjectReader() {
        Object value = this.objectReader.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.objectReader;
            synchronized (atomicReference) {
                value = this.objectReader.get();
                if (value == null) {
                    ObjectReader actualValue = this.createObjectReader();
                    value = actualValue == null ? this.objectReader : actualValue;
                    this.objectReader.set(value);
                }
            }
        }
        return (ObjectReader)(value == this.objectReader ? null : value);
    }
}

