/*
 * Decompiled with CFR 0.152.
 */
package net.lightoze.jooq.postgresql.guava;

import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.sql.SQLException;
import net.lightoze.jooq.AbstractObjectBinding;
import org.jooq.Converter;
import org.postgresql.util.PGobject;

public abstract class AbstractRangeBinding<T extends Comparable>
extends AbstractObjectBinding<Range<T>> {
    private final String type;

    protected AbstractRangeBinding(String type) {
        this.type = type;
    }

    protected abstract Range<T> getEmpty();

    protected abstract T parse(String var1);

    protected abstract String format(T var1);

    public Converter<Object, Range<T>> converter() {
        return new Converter<Object, Range<T>>(){

            public Range<T> from(Object object) {
                if (object == null) {
                    return null;
                }
                PGobject obj = (PGobject)object;
                Preconditions.checkArgument((boolean)AbstractRangeBinding.this.type.equals(obj.getType()));
                String str = obj.getValue();
                if (str.equals("empty")) {
                    return AbstractRangeBinding.this.getEmpty();
                }
                BoundType lowerBound = str.charAt(0) == '[' ? BoundType.CLOSED : BoundType.OPEN;
                BoundType upperBound = str.charAt(str.length() - 1) == ']' ? BoundType.CLOSED : BoundType.OPEN;
                int separator = str.indexOf(44);
                Object lower = this.parseImpl(str.substring(1, separator));
                Object upper = this.parseImpl(str.substring(separator + 1, str.length() - 1));
                if (lower == null) {
                    if (upper == null) {
                        return Range.all();
                    }
                    return Range.upTo(upper, (BoundType)upperBound);
                }
                if (upper == null) {
                    return Range.downTo(lower, (BoundType)lowerBound);
                }
                return Range.range(lower, (BoundType)lowerBound, upper, (BoundType)upperBound);
            }

            private T parseImpl(String text) {
                return text.isEmpty() ? null : (Object)AbstractRangeBinding.this.parse(text);
            }

            public Object to(Range<T> range) {
                Object str;
                if (range == null) {
                    return null;
                }
                if (range.isEmpty()) {
                    str = "empty";
                } else {
                    Object object = str = range.hasLowerBound() && range.lowerBoundType() == BoundType.CLOSED ? "[" : "(";
                    if (range.hasLowerBound()) {
                        str = (String)str + AbstractRangeBinding.this.format(range.lowerEndpoint());
                    }
                    str = (String)str + ",";
                    if (range.hasUpperBound()) {
                        str = (String)str + AbstractRangeBinding.this.format(range.upperEndpoint());
                    }
                    str = (String)str + (char)(range.hasUpperBound() && range.upperBoundType() == BoundType.CLOSED ? 93 : 41);
                }
                PGobject object = new PGobject();
                object.setType(AbstractRangeBinding.this.type);
                try {
                    object.setValue((String)str);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
                return object;
            }

            public Class<Object> fromType() {
                return Object.class;
            }

            public Class<Range<T>> toType() {
                return Range.class;
            }
        };
    }
}

