/*
 * Decompiled with CFR 0.152.
 */
package net.lightoze.jooq.postgresql;

import java.time.Duration;
import net.lightoze.jooq.AbstractObjectBinding;
import org.jooq.Converter;
import org.postgresql.util.PGInterval;

public class DurationBinding
extends AbstractObjectBinding<Duration> {
    public Converter<Object, Duration> converter() {
        return new Converter<Object, Duration>(){

            public Duration from(Object object) {
                if (object == null) {
                    return null;
                }
                PGInterval interval = (PGInterval)object;
                if (interval.getYears() != 0) {
                    throw new IllegalArgumentException("Duration cannot handle years");
                }
                if (interval.getMonths() != 0) {
                    throw new IllegalArgumentException("Duration cannot handle months");
                }
                long floor = (long)interval.getSeconds();
                return Duration.ofSeconds((long)(((interval.getDays() * 24 + interval.getHours()) * 60 + interval.getMinutes()) * 60) + floor, (long)((interval.getSeconds() - (double)floor) * 1.0E9));
            }

            public PGInterval to(Duration duration) {
                if (duration == null) {
                    return null;
                }
                long seconds = duration.getSeconds();
                int hours = Math.toIntExact(seconds / 3600L);
                int minutes = (int)(seconds / 60L % 60L);
                return new PGInterval(0, 0, 0, hours, minutes, 1.0E-9 * (double)duration.getNano() + (double)(seconds %= 60L));
            }

            public Class<Object> fromType() {
                return Object.class;
            }

            public Class<Duration> toType() {
                return Duration.class;
            }
        };
    }
}

