/*
 * Decompiled with CFR 0.152.
 */
package net.lightoze.jooq.postgresql.notify;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.postgresql.PGConnection;
import org.postgresql.PGNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NotificationListener {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String[] channels = new String[0];
    private long retryDelayMillis = 5000L;
    private int fetchTimeoutMillis = 1000;
    private volatile boolean running;

    public void setChannels(String ... channels) {
        this.channels = channels;
    }

    protected abstract Connection getConnection() throws SQLException;

    protected abstract void closeConnection(Connection var1) throws SQLException;

    protected abstract void receiveNotification(PGNotification var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run() {
        while (this.isRunning()) {
            Connection conn;
            try {
                conn = this.getConnection();
            }
            catch (Throwable e) {
                this.log.error("Could not get a connection", e);
                try {
                    Thread.sleep(this.retryDelayMillis);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try {
                conn.setAutoCommit(true);
                for (String channel : this.channels) {
                    try (Statement stmt = conn.createStatement();){
                        stmt.execute("LISTEN " + channel);
                    }
                }
                while (this.isRunning()) {
                    PGNotification[] pGNotificationArray = null;
                    try (Statement stmt = conn.createStatement();){
                        stmt.execute("SELECT 1");
                    }
                    catch (Throwable object) {
                        pGNotificationArray = object;
                        throw object;
                    }
                    PGNotification[] notifications = conn.unwrap(PGConnection.class).getNotifications(this.fetchTimeoutMillis);
                    if (notifications == null) continue;
                    for (PGNotification notification : notifications) {
                        try {
                            this.receiveNotification(notification);
                        }
                        catch (Throwable e) {
                            this.log.error("Error processing notification {} ({}) from {}", new Object[]{notification.getName(), notification.getParameter(), notification.getPID(), e});
                        }
                    }
                }
            }
            catch (Throwable e) {
                this.log.error("Error while listening for notifications", e);
                try {
                    Thread.sleep(this.retryDelayMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                try {
                    this.closeConnection(conn);
                }
                catch (Throwable e) {
                    this.log.warn("Error closing connection", e);
                }
            }
        }
    }

    public String[] getChannels() {
        return this.channels;
    }

    public long getRetryDelayMillis() {
        return this.retryDelayMillis;
    }

    public void setRetryDelayMillis(long retryDelayMillis) {
        this.retryDelayMillis = retryDelayMillis;
    }

    public int getFetchTimeoutMillis() {
        return this.fetchTimeoutMillis;
    }

    public void setFetchTimeoutMillis(int fetchTimeoutMillis) {
        this.fetchTimeoutMillis = fetchTimeoutMillis;
    }

    public boolean isRunning() {
        return this.running;
    }

    protected void setRunning(boolean running) {
        this.running = running;
    }
}

