/*
 * Decompiled with CFR 0.152.
 */
package net.lightoze.jooq.postgresql.json;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.concurrent.atomic.AtomicReference;
import org.jooq.Converter;

public abstract class AbstractJacksonConverter<O, T>
implements Converter<O, T> {
    private final AtomicReference<Object> objectWriter = new AtomicReference();
    private final AtomicReference<Object> objectReader = new AtomicReference();
    private final JavaType type;

    public AbstractJacksonConverter() {
        this.type = this.resolveType();
    }

    public AbstractJacksonConverter(JavaType type) {
        this.type = type;
    }

    protected ObjectMapper getMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.findAndRegisterModules();
        return mapper;
    }

    protected T getNull() {
        return null;
    }

    protected boolean isNull(T value) {
        return false;
    }

    protected ObjectWriter createObjectWriter() {
        return this.getMapper().writerFor(this.type);
    }

    protected ObjectReader createObjectReader() {
        return this.getMapper().readerFor(this.type);
    }

    public Class<T> toType() {
        return this.type.getRawClass();
    }

    private JavaType resolveType() {
        JavaType selfType = this.getMapper().constructType(this.getClass());
        JavaType[] typeParameters = selfType.findTypeParameters(AbstractJacksonConverter.class);
        if (typeParameters.length == 2) {
            return typeParameters[1];
        }
        throw new UnsupportedOperationException("Could not resolve value type for converter " + this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectWriter getObjectWriter() {
        Object value = this.objectWriter.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.objectWriter;
            synchronized (atomicReference) {
                value = this.objectWriter.get();
                if (value == null) {
                    ObjectWriter actualValue = this.createObjectWriter();
                    value = actualValue == null ? this.objectWriter : actualValue;
                    this.objectWriter.set(value);
                }
            }
        }
        return (ObjectWriter)(value == this.objectWriter ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectReader getObjectReader() {
        Object value = this.objectReader.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.objectReader;
            synchronized (atomicReference) {
                value = this.objectReader.get();
                if (value == null) {
                    ObjectReader actualValue = this.createObjectReader();
                    value = actualValue == null ? this.objectReader : actualValue;
                    this.objectReader.set(value);
                }
            }
        }
        return (ObjectReader)(value == this.objectReader ? null : value);
    }
}

