/*
 * Decompiled with CFR 0.152.
 */
package net.lightoze.jooq.postgresql;

import net.lightoze.jooq.AbstractObjectBinding;
import org.jooq.Binding;
import org.jooq.Converter;
import org.jooq.DataType;
import org.jooq.SQLDialect;
import org.jooq.impl.DefaultDataType;
import org.locationtech.jts.geom.Coordinate;
import org.postgresql.geometric.PGpoint;

public class CoordinateBinding
extends AbstractObjectBinding<Coordinate> {
    public static final DataType<Coordinate> TYPE = new DefaultDataType(SQLDialect.POSTGRES, PGpoint.class, "point").asConvertedDataType((Binding)new CoordinateBinding());

    public Converter<Object, Coordinate> converter() {
        return new Converter<Object, Coordinate>(){

            public Coordinate from(Object object) {
                if (object == null) {
                    return null;
                }
                PGpoint point = (PGpoint)object;
                return new Coordinate(point.x, point.y);
            }

            public Object to(Coordinate coordinate) {
                if (coordinate == null) {
                    return null;
                }
                if (coordinate.z != Double.NaN) {
                    throw new IllegalArgumentException("Z-ordinate is not supported by point type");
                }
                return new PGpoint(coordinate.x, coordinate.y);
            }

            public Class<Object> fromType() {
                return Object.class;
            }

            public Class<Coordinate> toType() {
                return Coordinate.class;
            }
        };
    }
}

