/*
 * Decompiled with CFR 0.152.
 */
package net.lightoze.jooq;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import net.lightoze.jooq.AbstractArrayBinding;
import org.jooq.Converter;
import org.jooq.DataType;

public abstract class PrimitiveListBinding<T>
extends AbstractArrayBinding<T, List<T>> {
    private final DataType<T> type;
    private final T[] emptyArray;

    public PrimitiveListBinding(DataType<T> type) {
        this.type = type;
        this.emptyArray = (Object[])Array.newInstance(type.getType(), 0);
    }

    @Override
    protected String typeName() {
        return this.type.getTypeName();
    }

    public Converter<T[], List<T>> converter() {
        return new Converter<T[], List<T>>(){

            public List<T> from(T[] arr) {
                if (arr == null) {
                    return null;
                }
                return Arrays.asList(arr);
            }

            public T[] to(List<T> list) {
                return list.toArray(PrimitiveListBinding.this.emptyArray);
            }

            public Class<T[]> fromType() {
                return PrimitiveListBinding.this.type.getArrayType();
            }

            public Class<List<T>> toType() {
                return List.class;
            }
        };
    }
}

