/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.mitm.util;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import net.lightbody.bmp.mitm.exception.KeyStoreAccessException;

public class KeyStoreUtil {
    public static KeyStore createEmptyKeyStore(String keyStoreType, String provider) {
        KeyStore keyStore;
        if (keyStoreType == null) {
            keyStoreType = KeyStore.getDefaultType();
        }
        try {
            keyStore = provider == null ? KeyStore.getInstance(keyStoreType) : KeyStore.getInstance(keyStoreType, provider);
            keyStore.load(null, null);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
            throw new KeyStoreAccessException("Error creating or initializing new KeyStore of type: " + keyStoreType, e);
        }
        return keyStore;
    }

    public static KeyStore createRootCertificateKeyStore(String keyStoreType, X509Certificate certificate, String privateKeyAlias, PrivateKey privateKey, String privateKeyPassword, String provider) {
        if (privateKeyPassword == null) {
            throw new IllegalArgumentException("Must specify a KeyStore password");
        }
        KeyStore newKeyStore = KeyStoreUtil.createEmptyKeyStore(keyStoreType, provider);
        try {
            newKeyStore.setKeyEntry(privateKeyAlias, privateKey, privateKeyPassword.toCharArray(), new Certificate[]{certificate});
        }
        catch (KeyStoreException e) {
            throw new KeyStoreAccessException("Unable to store certificate and private key in KeyStore", e);
        }
        return newKeyStore;
    }

    public static KeyManager[] getKeyManagers(KeyStore keyStore, String keyStorePassword, String keyManagerAlgorithm, String provider) {
        if (keyManagerAlgorithm == null) {
            keyManagerAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        }
        try {
            KeyManagerFactory kmf = provider == null ? KeyManagerFactory.getInstance(keyManagerAlgorithm) : KeyManagerFactory.getInstance(keyManagerAlgorithm, provider);
            kmf.init(keyStore, keyStorePassword.toCharArray());
            return kmf.getKeyManagers();
        }
        catch (KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | UnrecoverableKeyException e) {
            throw new KeyStoreAccessException("Unable to get KeyManagers for KeyStore", e);
        }
    }
}

