/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.mitm.keys;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import net.lightbody.bmp.mitm.exception.KeyGeneratorException;
import net.lightbody.bmp.mitm.keys.KeyGenerator;

public class RSAKeyGenerator
implements KeyGenerator {
    private static final String RSA_KEY_GEN_ALGORITHM = "RSA";
    private static final int DEFAULT_KEY_SIZE = 2048;
    private final int keySize;

    public RSAKeyGenerator() {
        this.keySize = 2048;
    }

    public RSAKeyGenerator(int keySize) {
        this.keySize = keySize;
    }

    @Override
    public KeyPair generate() {
        KeyPairGenerator generator;
        try {
            generator = KeyPairGenerator.getInstance(RSA_KEY_GEN_ALGORITHM);
            generator.initialize(this.keySize);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyGeneratorException("Unable to generate " + this.keySize + "-bit RSA public/private key pair", e);
        }
        return generator.generateKeyPair();
    }

    public String toString() {
        return "RSA (" + this.keySize + ")";
    }
}

