/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.mitm;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.File;
import java.io.StringReader;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import net.lightbody.bmp.mitm.CertificateAndKey;
import net.lightbody.bmp.mitm.CertificateAndKeySource;
import net.lightbody.bmp.mitm.tools.DefaultSecurityProviderTool;
import net.lightbody.bmp.mitm.tools.SecurityProviderTool;
import net.lightbody.bmp.mitm.util.EncryptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PemFileCertificateSource
implements CertificateAndKeySource {
    private static final Logger log = LoggerFactory.getLogger(PemFileCertificateSource.class);
    private final File certificateFile;
    private final File privateKeyFile;
    private final String privateKeyPassword;
    private SecurityProviderTool securityProviderTool = new DefaultSecurityProviderTool();
    private final Supplier<CertificateAndKey> certificateAndKey = Suppliers.memoize((Supplier)new Supplier<CertificateAndKey>(){

        public CertificateAndKey get() {
            return PemFileCertificateSource.this.loadCertificateAndKeyFiles();
        }
    });

    public PemFileCertificateSource(File certificateFile, File privateKeyFile, String privateKeyPassword) {
        this.certificateFile = certificateFile;
        this.privateKeyFile = privateKeyFile;
        this.privateKeyPassword = privateKeyPassword;
    }

    public PemFileCertificateSource certificateTool(SecurityProviderTool securityProviderTool) {
        this.securityProviderTool = securityProviderTool;
        return this;
    }

    @Override
    public CertificateAndKey load() {
        return (CertificateAndKey)this.certificateAndKey.get();
    }

    private CertificateAndKey loadCertificateAndKeyFiles() {
        if (this.certificateFile == null) {
            throw new IllegalArgumentException("PEM root certificate file cannot be null");
        }
        if (this.privateKeyFile == null) {
            throw new IllegalArgumentException("PEM private key file cannot be null");
        }
        if (this.privateKeyPassword == null) {
            log.warn("Attempting to load private key from file without password. Private keys should be password-protected.");
        }
        String pemEncodedCertificate = EncryptionUtil.readPemStringFromFile(this.certificateFile);
        X509Certificate certificate = this.securityProviderTool.decodePemEncodedCertificate(new StringReader(pemEncodedCertificate));
        String pemEncodedPrivateKey = EncryptionUtil.readPemStringFromFile(this.privateKeyFile);
        PrivateKey privateKey = this.securityProviderTool.decodePemEncodedPrivateKey(new StringReader(pemEncodedPrivateKey), this.privateKeyPassword);
        return new CertificateAndKey(certificate, privateKey);
    }
}

