/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.user.query.handler;

import com.networknt.httpstring.AttachmentConstants;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.NioUtils;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.util.Map;
import net.lightapi.portal.user.query.UserQueryStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/user/queryUserByTypeEntityId/0.1.0")
public class QueryUserByTypeEntityId
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(QueryUserByTypeEntityId.class);
    static final String USER_NOT_FOUND_BY_ID = "ERR11609";
    static final String USER_QUERY_DENIED = "ERR11618";

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        Result result;
        String roles;
        if (logger.isTraceEnabled()) {
            logger.trace("input = {}", input);
        }
        Map map = (Map)input;
        String userType = (String)map.get("userType");
        String entityId = (String)map.get("entityId");
        if (logger.isTraceEnabled()) {
            logger.trace("userType = {} entityId = {}", (Object)userType, (Object)entityId);
        }
        String email = null;
        boolean isAdmin = false;
        Map auditInfo = (Map)exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
        if (auditInfo != null && (email = (String)auditInfo.get("user_id")) != null && (roles = (String)auditInfo.get("roles")) != null && roles.contains("admin")) {
            isAdmin = true;
        }
        if ((result = UserQueryStreams.dbProvider.queryUserByTypeEntityId(userType, entityId)) != null && result.isSuccess()) {
            if (email != null && !email.equals(result.getResult()) && !isAdmin) {
                return NioUtils.toByteBuffer((String)this.getStatus(exchange, USER_QUERY_DENIED, new Object[]{email, entityId}));
            }
            return NioUtils.toByteBuffer((String)((String)result.getResult()));
        }
        return NioUtils.toByteBuffer((String)this.getStatus(exchange, USER_NOT_FOUND_BY_ID, new Object[]{entityId}));
    }
}

