/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.user.query.handler;

import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.NioUtils;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.util.Map;
import net.lightapi.portal.user.query.UserQueryStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/user/queryUserById/0.1.0")
public class QueryUserById
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(QueryUserById.class);
    static final String USER_NOT_FOUND_BY_ID = "ERR11609";

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        Result result;
        if (logger.isTraceEnabled()) {
            logger.trace("input = {}", input);
        }
        Map map = (Map)input;
        String userId = (String)map.get("userId");
        if (logger.isTraceEnabled()) {
            logger.trace("userId = {}", (Object)userId);
        }
        if ((result = UserQueryStreams.dbProvider.queryUserById(userId)) != null && result.isSuccess()) {
            return NioUtils.toByteBuffer((String)((String)result.getResult()));
        }
        return NioUtils.toByteBuffer((String)this.getStatus(exchange, USER_NOT_FOUND_BY_ID, new Object[]{userId}));
    }
}

