/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.user.query;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.config.Config;
import com.networknt.config.JsonMapper;
import com.networknt.db.provider.DbProvider;
import com.networknt.kafka.common.KafkaStreamsConfig;
import com.networknt.kafka.streams.LightStreams;
import com.networknt.oas.model.Operation;
import com.networknt.oas.model.Path;
import com.networknt.oas.model.SecurityParameter;
import com.networknt.oas.model.SecurityRequirement;
import com.networknt.openapi.OpenApiHelper;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.UuidUtil;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.lightapi.portal.PortalConfig;
import net.lightapi.portal.PortalUtil;
import net.lightapi.portal.db.PortalDbProvider;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.errors.StreamsUncaughtExceptionHandler;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.To;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserQueryStreams
implements LightStreams {
    private static final Logger logger = LoggerFactory.getLogger(UserQueryStreams.class);
    private static final String APP = "user";
    static final KafkaStreamsConfig streamsConfig = (KafkaStreamsConfig)Config.getInstance().getJsonObjectConfig("kafka-streams", KafkaStreamsConfig.class);
    static final PortalConfig portalConfig = (PortalConfig)Config.getInstance().getJsonObjectConfig("portal", PortalConfig.class);
    public static PortalDbProvider dbProvider = (PortalDbProvider)SingletonServiceFactory.getBean(DbProvider.class);
    KafkaStreams userStreams;

    public UserQueryStreams() {
        logger.info("UserQueryStreams is created");
    }

    private void startUserStreams(String ip, int port) {
        Topology topology = new Topology();
        topology.addSource("SourceTopicProcessor", new String[]{portalConfig.getTopic()});
        topology.addProcessor("UserEventProcessor", UserEventProcessor::new, new String[]{"SourceTopicProcessor"});
        topology.addSink("ScheduleProcessor", portalConfig.getScheduleTopic(), new String[]{"UserEventProcessor"});
        Properties streamsProps = new Properties();
        streamsProps.putAll((Map<?, ?>)streamsConfig.getProperties());
        streamsProps.put("default.key.serde", Serdes.ByteArray().getClass());
        streamsProps.put("default.value.serde", Serdes.ByteArray().getClass());
        streamsProps.put("application.id", portalConfig.getUserApplicationId());
        streamsProps.put("application.server", ip + ":" + port);
        this.userStreams = new KafkaStreams(topology, streamsProps);
        this.userStreams.setUncaughtExceptionHandler(ex -> {
            logger.error("Kafka-Streams uncaught exception occurred. Stream will be replaced with new thread", ex);
            return StreamsUncaughtExceptionHandler.StreamThreadExceptionResponse.REPLACE_THREAD;
        });
        if (streamsConfig.isCleanUp()) {
            this.userStreams.cleanUp();
        }
        this.userStreams.start();
    }

    public void start(String ip, int port) {
        if (logger.isDebugEnabled()) {
            logger.debug("UserStreams is starting...");
        }
        this.startUserStreams(ip, port);
    }

    public void close() {
        if (logger.isDebugEnabled()) {
            logger.debug("UserStreams is closing...");
        }
        this.userStreams.close();
    }

    private static List<Map<String, Object>> parseSpec(String hostId, String apiId, String apiVersion, String apiType, String spec) {
        ArrayList<Map<String, Object>> endpoints = new ArrayList<Map<String, Object>>();
        switch (apiType) {
            case "openapi": {
                OpenApiHelper helper = new OpenApiHelper(spec);
                String basePath = helper.basePath;
                Map paths = helper.openApi3.getPaths();
                for (Map.Entry pathPair : paths.entrySet()) {
                    String path = (String)pathPair.getKey();
                    for (Map.Entry entries : ((Path)pathPair.getValue()).getOperations().entrySet()) {
                        HashMap<String, Object> endpointMap = new HashMap<String, Object>();
                        String method = (String)entries.getKey();
                        Operation operation = (Operation)entries.getValue();
                        String endpointName = operation.getOperationId();
                        String endpointDesc = operation.getSummary();
                        String endpoint = basePath + path + "@" + method;
                        List securityRequirements = operation.getSecurityRequirements();
                        List scopes = null;
                        if (securityRequirements != null) {
                            for (SecurityRequirement requirement : securityRequirements) {
                                String oauth2Name;
                                SecurityParameter securityParameter = null;
                                Iterator iterator = helper.oauth2Names.iterator();
                                while (iterator.hasNext() && (securityParameter = requirement.getRequirement(oauth2Name = (String)iterator.next())) == null) {
                                }
                                if (securityParameter != null) {
                                    scopes = securityParameter.getParameters();
                                }
                                if (scopes == null) continue;
                                break;
                            }
                        }
                        endpointMap.put("scopes", scopes);
                        endpointMap.put("endpointId", UuidUtil.getUUID().toString());
                        endpointMap.put("endpoint", endpoint);
                        endpointMap.put("httpMethod", method);
                        endpointMap.put("endpointPath", path);
                        endpointMap.put("endpointName", endpointName);
                        endpointMap.put("endpointDesc", endpointDesc);
                        endpoints.add(endpointMap);
                    }
                }
                break;
            }
            case "graphql": {
                break;
            }
            case "hybrid": {
                Map specMap = PortalUtil.yamlToMap((String)spec);
                String host = (String)specMap.get("host");
                String service = (String)specMap.get("service");
                List actionList = (List)specMap.get("action");
                for (Map action : actionList) {
                    HashMap<String, Object> endpointMap = new HashMap<String, Object>();
                    String endpoint = host + "/" + service + "/" + String.valueOf(action.get("name")) + "/" + String.valueOf(action.get("version"));
                    endpointMap.put("endpointId", UuidUtil.getUUID().toString());
                    endpointMap.put("endpoint", endpoint);
                    endpointMap.put("endpointName", action.get("handler"));
                    if (action.get("scope") != null) {
                        ArrayList<String> list = new ArrayList<String>();
                        list.add((String)action.get("scope"));
                        endpointMap.put("scopes", list);
                    }
                    endpoints.add(endpointMap);
                }
                break;
            }
            default: {
                logger.error("ServiceSpecUpdatedEvent with unknown apiType {} for hostId {} apiId {} apiVersion {}", new Object[]{apiType, hostId, apiId, apiVersion});
            }
        }
        return endpoints;
    }

    public static class UserEventProcessor
    extends AbstractProcessor<byte[], byte[]> {
        private ProcessorContext pc;

        public void init(ProcessorContext pc) {
            if (logger.isInfoEnabled()) {
                logger.info("Processor initialized");
            }
            this.pc = pc;
        }

        public void process(byte[] key, byte[] value) {
            try {
                Map event = (Map)Config.getInstance().getMapper().readValue(value, (TypeReference)new TypeReference<HashMap<String, Object>>(this){});
                String eventType = (String)event.get("type");
                Map data = (Map)event.get("data");
                if (logger.isTraceEnabled()) {
                    logger.trace("Event type {} event {}", (Object)eventType, (Object)JsonMapper.toJson((Object)event));
                }
                switch ((String)event.get("type")) {
                    case "UserCreatedEvent": {
                        dbProvider.createUser(event);
                        break;
                    }
                    case "SocialUserCreatedEvent": {
                        dbProvider.createSocialUser(event);
                        break;
                    }
                    case "UserConfirmedEvent": {
                        dbProvider.confirmUser(event);
                        break;
                    }
                    case "UserVerifiedEvent": {
                        dbProvider.verifyUser(event);
                        break;
                    }
                    case "UserUpdatedEvent": {
                        dbProvider.updateUser(event);
                        break;
                    }
                    case "PasswordForgotEvent": {
                        dbProvider.forgetPassword(event);
                        break;
                    }
                    case "PasswordResetEvent": {
                        dbProvider.resetPassword(event);
                        break;
                    }
                    case "PasswordChangedEvent": {
                        dbProvider.changePassword(event);
                        break;
                    }
                    case "UserDeletedEvent": {
                        dbProvider.deleteUser(event);
                        break;
                    }
                    case "OrgCreatedEvent": {
                        dbProvider.createOrg(event);
                        break;
                    }
                    case "OrgUpdatedEvent": {
                        dbProvider.updateOrg(event);
                        break;
                    }
                    case "OrgDeletedEvent": {
                        dbProvider.deleteOrg(event);
                        break;
                    }
                    case "HostCreatedEvent": {
                        dbProvider.createHost(event);
                        break;
                    }
                    case "HostUpdatedEvent": {
                        dbProvider.updateHost(event);
                        break;
                    }
                    case "HostDeletedEvent": {
                        dbProvider.deleteHost(event);
                        break;
                    }
                    case "HostSwitchedEvent": {
                        dbProvider.switchHost(event);
                        break;
                    }
                    case "PaymentUpdatedEvent": {
                        dbProvider.updatePayment(event);
                        break;
                    }
                    case "PaymentDeletedEvent": {
                        dbProvider.deletePayment(event);
                        break;
                    }
                    case "OrderCreatedEvent": {
                        break;
                    }
                    case "OrderCancelledEvent": {
                        break;
                    }
                    case "OrderDeliveredEvent": {
                        break;
                    }
                    case "PrivateMessageSentEvent": {
                        dbProvider.sendPrivateMessage(event);
                        break;
                    }
                    case "AttributeCreatedEvent": {
                        dbProvider.createAttribute(event);
                        break;
                    }
                    case "AttributeUpdatedEvent": {
                        dbProvider.updateAttribute(event);
                        break;
                    }
                    case "AttributeDeletedEvent": {
                        dbProvider.deleteAttribute(event);
                        break;
                    }
                    case "AttributePermissionCreatedEvent": {
                        dbProvider.createAttributePermission(event);
                        break;
                    }
                    case "AttributePermissionUpdatedEvent": {
                        dbProvider.updateAttributePermission(event);
                        break;
                    }
                    case "AttributePermissionDeletedEvent": {
                        dbProvider.deleteAttributePermission(event);
                        break;
                    }
                    case "AttributeUserCreatedEvent": {
                        dbProvider.createAttributeUser(event);
                        break;
                    }
                    case "AttributeUserUpdatedEvent": {
                        dbProvider.updateAttributeUser(event);
                        break;
                    }
                    case "AttributeUserDeletedEvent": {
                        dbProvider.deleteAttributeUser(event);
                        break;
                    }
                    case "AttributeRowFilterCreatedEvent": {
                        dbProvider.createAttributeRowFilter(event);
                        break;
                    }
                    case "AttributeRowFilterUpdatedEvent": {
                        dbProvider.updateAttributeRowFilter(event);
                        break;
                    }
                    case "AttributeRowFilterDeletedEvent": {
                        dbProvider.deleteAttributeRowFilter(event);
                        break;
                    }
                    case "AttributeColFilterCreatedEvent": {
                        dbProvider.createAttributeColFilter(event);
                        break;
                    }
                    case "AttributeColFilterUpdatedEvent": {
                        dbProvider.updateAttributeColFilter(event);
                        break;
                    }
                    case "AttributeColFilterDeletedEvent": {
                        dbProvider.deleteAttributeColFilter(event);
                        break;
                    }
                    case "GroupCreatedEvent": {
                        dbProvider.createGroup(event);
                        break;
                    }
                    case "GroupUpdatedEvent": {
                        dbProvider.updateGroup(event);
                        break;
                    }
                    case "GroupDeletedEvent": {
                        dbProvider.deleteGroup(event);
                        break;
                    }
                    case "GroupPermissionCreatedEvent": {
                        dbProvider.createGroupPermission(event);
                        break;
                    }
                    case "GroupPermissionDeletedEvent": {
                        dbProvider.deleteGroupPermission(event);
                        break;
                    }
                    case "GroupUserCreatedEvent": {
                        dbProvider.createGroupUser(event);
                        break;
                    }
                    case "GroupUserUpdatedEvent": {
                        dbProvider.updateGroupUser(event);
                        break;
                    }
                    case "GroupUserDeletedEvent": {
                        dbProvider.deleteGroupUser(event);
                        break;
                    }
                    case "GroupRowFilterCreatedEvent": {
                        dbProvider.createGroupRowFilter(event);
                        break;
                    }
                    case "GroupRowFilterUpdatedEvent": {
                        dbProvider.updateGroupRowFilter(event);
                        break;
                    }
                    case "GroupRowFilterDeletedEvent": {
                        dbProvider.deleteGroupRowFilter(event);
                        break;
                    }
                    case "GroupColFilterCreatedEvent": {
                        dbProvider.createGroupColFilter(event);
                        break;
                    }
                    case "GroupColFilterUpdatedEvent": {
                        dbProvider.updateGroupColFilter(event);
                        break;
                    }
                    case "GroupColFilterDeletedEvent": {
                        dbProvider.deleteGroupColFilter(event);
                        break;
                    }
                    case "RoleCreatedEvent": {
                        dbProvider.createRole(event);
                        break;
                    }
                    case "RoleUpdatedEvent": {
                        dbProvider.updateRole(event);
                        break;
                    }
                    case "RoleDeletedEvent": {
                        dbProvider.deleteRole(event);
                        break;
                    }
                    case "RolePermissionCreatedEvent": {
                        dbProvider.createRolePermission(event);
                        break;
                    }
                    case "RolePermissionDeletedEvent": {
                        dbProvider.deleteRolePermission(event);
                        break;
                    }
                    case "RoleUserCreatedEvent": {
                        dbProvider.createRoleUser(event);
                        break;
                    }
                    case "RoleUserUpdatedEvent": {
                        dbProvider.updateRoleUser(event);
                        break;
                    }
                    case "RoleUserDeletedEvent": {
                        dbProvider.deleteRoleUser(event);
                        break;
                    }
                    case "RoleRowFilterCreatedEvent": {
                        dbProvider.createRoleRowFilter(event);
                        break;
                    }
                    case "RoleRowFilterUpdatedEvent": {
                        dbProvider.updateRoleRowFilter(event);
                        break;
                    }
                    case "RoleRowFilterDeletedEvent": {
                        dbProvider.deleteRoleRowFilter(event);
                        break;
                    }
                    case "RoleColFilterCreatedEvent": {
                        dbProvider.createRoleColFilter(event);
                        break;
                    }
                    case "RoleColFilterUpdatedEvent": {
                        dbProvider.updateRoleColFilter(event);
                        break;
                    }
                    case "RoleColFilterDeletedEvent": {
                        dbProvider.deleteRoleColFilter(event);
                        break;
                    }
                    case "PositionCreatedEvent": {
                        dbProvider.createPosition(event);
                        break;
                    }
                    case "PositionUpdatedEvent": {
                        dbProvider.updatePosition(event);
                        break;
                    }
                    case "PositionDeletedEvent": {
                        dbProvider.deletePosition(event);
                        break;
                    }
                    case "PositionPermissionCreatedEvent": {
                        dbProvider.createPositionPermission(event);
                        break;
                    }
                    case "PositionPermissionDeletedEvent": {
                        dbProvider.deletePositionPermission(event);
                        break;
                    }
                    case "PositionUserCreatedEvent": {
                        dbProvider.createPositionUser(event);
                        break;
                    }
                    case "PositionUserUpdatedEvent": {
                        dbProvider.updatePositionUser(event);
                        break;
                    }
                    case "PositionUserDeletedEvent": {
                        dbProvider.deletePositionUser(event);
                        break;
                    }
                    case "PositionRowFilterCreatedEvent": {
                        dbProvider.createPositionRowFilter(event);
                        break;
                    }
                    case "PositionRowFilterUpdatedEvent": {
                        dbProvider.updatePositionRowFilter(event);
                        break;
                    }
                    case "PositionRowFilterDeletedEvent": {
                        dbProvider.deletePositionRowFilter(event);
                        break;
                    }
                    case "PositionColFilterCreatedEvent": {
                        dbProvider.createPositionColFilter(event);
                        break;
                    }
                    case "PositionColFilterUpdatedEvent": {
                        dbProvider.updatePositionColFilter(event);
                        break;
                    }
                    case "PositionColFilterDeletedEvent": {
                        dbProvider.deletePositionColFilter(event);
                        break;
                    }
                    case "RuleCreatedEvent": {
                        dbProvider.createRule(event);
                        break;
                    }
                    case "RuleUpdatedEvent": {
                        dbProvider.updateRule(event);
                        break;
                    }
                    case "RuleDeletedEvent": {
                        dbProvider.deleteRule(event);
                        break;
                    }
                    case "SchemaCreatedEvent": {
                        dbProvider.createSchema(event);
                        break;
                    }
                    case "SchemaUpdatedEvent": {
                        dbProvider.updateSchema(event);
                        break;
                    }
                    case "SchemaDeletedEvent": {
                        dbProvider.deleteSchema(event);
                        break;
                    }
                    case "ScheduleCreatedEvent": {
                        dbProvider.createSchedule(event);
                        this.pc.forward((Object)((String)data.get("scheduleId")).getBytes(StandardCharsets.UTF_8), (Object)value, To.child((String)"ScheduleProcessor"));
                        break;
                    }
                    case "ScheduleUpdatedEvent": {
                        this.pc.forward((Object)((String)data.get("scheduleId")).getBytes(StandardCharsets.UTF_8), (Object)To.child((String)"ScheduleProcessor"));
                        dbProvider.updateSchedule(event);
                        break;
                    }
                    case "ScheduleDeletedEvent": {
                        this.pc.forward((Object)((String)data.get("scheduleId")).getBytes(StandardCharsets.UTF_8), (Object)value, To.child((String)"ScheduleProcessor"));
                        dbProvider.deleteSchedule(event);
                        break;
                    }
                    case "PlatformQueriedEvent": {
                        break;
                    }
                    case "CategoryCreatedEvent": {
                        dbProvider.createCategory(event);
                        break;
                    }
                    case "CategoryUpdatedEvent": {
                        dbProvider.updateCategory(event);
                        break;
                    }
                    case "CategoryDeletedEvent": {
                        dbProvider.deleteCategory(event);
                        break;
                    }
                    case "TagCreatedEvent": {
                        dbProvider.createTag(event);
                        break;
                    }
                    case "TagUpdatedEvent": {
                        dbProvider.updateTag(event);
                        break;
                    }
                    case "TagDeletedEvent": {
                        dbProvider.deleteTag(event);
                        break;
                    }
                    case "ServiceCreatedEvent": {
                        dbProvider.createService(event);
                        break;
                    }
                    case "ServiceUpdatedEvent": {
                        dbProvider.updateService(event);
                        break;
                    }
                    case "ServiceDeletedEvent": {
                        dbProvider.deleteService(event);
                        break;
                    }
                    case "ServiceVersionCreatedEvent": {
                        Map map = (Map)event.get("data");
                        String spec = (String)map.get("spec");
                        List<Map<String, Object>> endpoints = null;
                        if (spec != null && !spec.isEmpty()) {
                            endpoints = UserQueryStreams.parseSpec((String)map.get("hostId"), (String)map.get("apiId"), (String)map.get("apiVersion"), (String)map.get("apiType"), spec);
                        }
                        dbProvider.createServiceVersion(event, endpoints);
                        break;
                    }
                    case "ServiceVersionUpdatedEvent": {
                        Map map = (Map)event.get("data");
                        String spec = (String)map.get("spec");
                        List<Map<String, Object>> endpoints = null;
                        if (spec != null && !spec.isEmpty()) {
                            endpoints = UserQueryStreams.parseSpec((String)map.get("hostId"), (String)map.get("apiId"), (String)map.get("apiVersion"), (String)map.get("apiType"), spec);
                        }
                        dbProvider.updateServiceVersion(event, endpoints);
                        break;
                    }
                    case "ServiceVersionDeletedEvent": {
                        dbProvider.deleteServiceVersion(event);
                        break;
                    }
                    case "EndpointRuleCreatedEvent": {
                        dbProvider.createEndpointRule(event);
                        break;
                    }
                    case "EndpointRuleDeletedEvent": {
                        dbProvider.deleteEndpointRule(event);
                        break;
                    }
                    case "ServiceSpecUpdatedEvent": {
                        Map map = (Map)event.get("data");
                        String spec = (String)map.get("spec");
                        List<Map<String, Object>> endpoints = null;
                        if (spec != null && !spec.isEmpty()) {
                            endpoints = UserQueryStreams.parseSpec((String)map.get("hostId"), (String)map.get("apiId"), (String)map.get("apiVersion"), (String)map.get("apiType"), spec);
                        }
                        dbProvider.updateServiceSpec(event, endpoints);
                        break;
                    }
                    case "AuthRefreshTokenCreatedEvent": {
                        dbProvider.createRefreshToken(event);
                        break;
                    }
                    case "AuthRefreshTokenDeletedEvent": {
                        dbProvider.deleteRefreshToken(event);
                        break;
                    }
                    case "AuthCodeCreatedEvent": {
                        dbProvider.createAuthCode(event);
                        break;
                    }
                    case "AuthCodeDeletedEvent": {
                        dbProvider.deleteAuthCode(event);
                        break;
                    }
                    case "AuthRefTokenCreatedEvent": {
                        break;
                    }
                    case "AuthRefTokenDeletedEvent": {
                        break;
                    }
                    case "AuthProviderCreatedEvent": {
                        dbProvider.createAuthProvider(event);
                        break;
                    }
                    case "AuthProviderRotatedEvent": {
                        dbProvider.rotateAuthProvider(event);
                        break;
                    }
                    case "AuthProviderUpdatedEvent": {
                        dbProvider.updateAuthProvider(event);
                        break;
                    }
                    case "AuthProviderDeletedEvent": {
                        dbProvider.deleteAuthProvider(event);
                        break;
                    }
                    case "ProductCreatedEvent": {
                        dbProvider.createProduct(event);
                        break;
                    }
                    case "ProductUpdatedEvent": {
                        dbProvider.updateProduct(event);
                        break;
                    }
                    case "ProductDeletedEvent": {
                        dbProvider.deleteProduct(event);
                        break;
                    }
                    case "ProductVersionEnvironmentCreatedEvent": {
                        dbProvider.createProductVersionEnvironment(event);
                        break;
                    }
                    case "ProductVersionEnvironmentDeletedEvent": {
                        dbProvider.deleteProductVersionEnvironment(event);
                        break;
                    }
                    case "ProductVersionPipelineCreatedEvent": {
                        dbProvider.createProductVersionPipeline(event);
                        break;
                    }
                    case "ProductVersionPipelineDeletedEvent": {
                        dbProvider.deleteProductVersionPipeline(event);
                        break;
                    }
                    case "ProductVersionConfigCreatedEvent": {
                        dbProvider.createProductVersionConfig(event);
                        break;
                    }
                    case "ProductVersionConfigDeletedEvent": {
                        dbProvider.deleteProductVersionConfig(event);
                        break;
                    }
                    case "ProductVersionConfigPropertyCreatedEvent": {
                        dbProvider.createProductVersionConfigProperty(event);
                        break;
                    }
                    case "ProductVersionConfigPropertyDeletedEvent": {
                        dbProvider.deleteProductVersionConfigProperty(event);
                        break;
                    }
                    case "PipelineCreatedEvent": {
                        dbProvider.createPipeline(event);
                        break;
                    }
                    case "PipelineUpdatedEvent": {
                        dbProvider.updatePipeline(event);
                        break;
                    }
                    case "PipelineDeletedEvent": {
                        dbProvider.deletePipeline(event);
                        break;
                    }
                    case "PlatformCreatedEvent": {
                        dbProvider.createPlatform(event);
                        break;
                    }
                    case "PlatformUpdatedEvent": {
                        dbProvider.updatePlatform(event);
                        break;
                    }
                    case "PlatformDeletedEvent": {
                        dbProvider.deletePlatform(event);
                        break;
                    }
                    case "InstanceCreatedEvent": {
                        dbProvider.createInstance(event);
                        break;
                    }
                    case "InstanceUpdatedEvent": {
                        dbProvider.updateInstance(event);
                        break;
                    }
                    case "InstanceDeletedEvent": {
                        dbProvider.deleteInstance(event);
                        break;
                    }
                    case "InstanceApiCreatedEvent": {
                        dbProvider.createInstanceApi(event);
                        break;
                    }
                    case "InstanceApiUpdatedEvent": {
                        dbProvider.updateInstanceApi(event);
                        break;
                    }
                    case "InstanceApiDeletedEvent": {
                        dbProvider.deleteInstanceApi(event);
                        break;
                    }
                    case "InstanceAppCreatedEvent": {
                        dbProvider.createInstanceApp(event);
                        break;
                    }
                    case "InstanceAppUpdatedEvent": {
                        dbProvider.updateInstanceApp(event);
                        break;
                    }
                    case "InstanceAppDeletedEvent": {
                        dbProvider.deleteInstanceApp(event);
                        break;
                    }
                    case "InstanceAppApiCreatedEvent": {
                        dbProvider.createInstanceAppApi(event);
                        break;
                    }
                    case "InstanceAppApiUpdatedEvent": {
                        dbProvider.updateInstanceAppApi(event);
                        break;
                    }
                    case "InstanceAppApiDeletedEvent": {
                        dbProvider.deleteInstanceAppApi(event);
                        break;
                    }
                    case "InstanceApiPathPrefixCreatedEvent": {
                        dbProvider.createInstanceApiPathPrefix(event);
                        break;
                    }
                    case "InstanceApiPathPrefixUpdatedEvent": {
                        dbProvider.updateInstanceApiPathPrefix(event);
                        break;
                    }
                    case "InstanceApiPathPrefixDeletedEvent": {
                        dbProvider.deleteInstanceApiPathPrefix(event);
                        break;
                    }
                    case "DeploymentCreatedEvent": {
                        dbProvider.createDeployment(event);
                        break;
                    }
                    case "DeploymentUpdatedEvent": {
                        dbProvider.updateDeployment(event);
                        break;
                    }
                    case "DeploymentJobIdUpdatedEvent": {
                        dbProvider.updateDeploymentJobId(event);
                        break;
                    }
                    case "DeploymentStatusUpdatedEvent": {
                        dbProvider.updateDeploymentStatus(event);
                        break;
                    }
                    case "DeploymentDeletedEvent": {
                        dbProvider.deleteDeployment(event);
                        break;
                    }
                    case "DeploymentInstanceCreatedEvent": {
                        dbProvider.createDeploymentInstance(event);
                        break;
                    }
                    case "DeploymentInstanceUpdatedEvent": {
                        dbProvider.updateDeploymentInstance(event);
                        break;
                    }
                    case "DeploymentInstanceDeletedEvent": {
                        dbProvider.deleteDeploymentInstance(event);
                        break;
                    }
                    case "ConfigCreatedEvent": {
                        dbProvider.createConfig(event);
                        break;
                    }
                    case "ConfigUpdatedEvent": {
                        dbProvider.updateConfig(event);
                        break;
                    }
                    case "ConfigDeletedEvent": {
                        dbProvider.deleteConfig(event);
                        break;
                    }
                    case "ConfigPropertyCreatedEvent": {
                        dbProvider.createConfigProperty(event);
                        break;
                    }
                    case "ConfigPropertyUpdatedEvent": {
                        dbProvider.updateConfigProperty(event);
                        break;
                    }
                    case "ConfigPropertyDeletedEvent": {
                        dbProvider.deleteConfigProperty(event);
                        break;
                    }
                    case "ConfigEnvironmentCreatedEvent": {
                        dbProvider.createConfigEnvironment(event);
                        break;
                    }
                    case "ConfigEnvironmentUpdatedEvent": {
                        dbProvider.updateConfigEnvironment(event);
                        break;
                    }
                    case "ConfigEnvironmentDeletedEvent": {
                        dbProvider.deleteConfigEnvironment(event);
                        break;
                    }
                    case "ConfigInstanceApiCreatedEvent": {
                        dbProvider.createConfigInstanceApi(event);
                        break;
                    }
                    case "ConfigInstanceApiUpdatedEvent": {
                        dbProvider.updateConfigInstanceApi(event);
                        break;
                    }
                    case "ConfigInstanceApiDeletedEvent": {
                        dbProvider.deleteConfigInstanceApi(event);
                        break;
                    }
                    case "ConfigInstanceAppCreatedEvent": {
                        dbProvider.createConfigInstanceApp(event);
                        break;
                    }
                    case "ConfigInstanceAppUpdatedEvent": {
                        dbProvider.updateConfigInstanceApp(event);
                        break;
                    }
                    case "ConfigInstanceAppDeletedEvent": {
                        dbProvider.deleteConfigInstanceApp(event);
                        break;
                    }
                    case "ConfigInstanceAppApiCreatedEvent": {
                        dbProvider.createConfigInstanceAppApi(event);
                        break;
                    }
                    case "ConfigInstanceAppApiUpdatedEvent": {
                        dbProvider.updateConfigInstanceAppApi(event);
                        break;
                    }
                    case "ConfigInstanceAppApiDeletedEvent": {
                        dbProvider.deleteConfigInstanceAppApi(event);
                        break;
                    }
                    case "ConfigInstanceFileCreatedEvent": {
                        dbProvider.createConfigInstanceFile(event);
                        break;
                    }
                    case "ConfigInstanceFileUpdatedEvent": {
                        dbProvider.updateConfigInstanceFile(event);
                        break;
                    }
                    case "ConfigInstanceFileDeletedEvent": {
                        dbProvider.deleteConfigInstanceFile(event);
                        break;
                    }
                    case "ConfigDeploymentInstanceCreatedEvent": {
                        dbProvider.createConfigDeploymentInstance(event);
                        break;
                    }
                    case "ConfigDeploymentInstanceUpdatedEvent": {
                        dbProvider.updateConfigDeploymentInstance(event);
                        break;
                    }
                    case "ConfigDeploymentInstanceDeletedEvent": {
                        dbProvider.deleteConfigDeploymentInstance(event);
                        break;
                    }
                    case "ConfigInstanceCreatedEvent": {
                        dbProvider.createConfigInstance(event);
                        break;
                    }
                    case "ConfigInstanceUpdatedEvent": {
                        dbProvider.updateConfigInstance(event);
                        break;
                    }
                    case "ConfigInstanceDeletedEvent": {
                        dbProvider.deleteConfigInstance(event);
                        break;
                    }
                    case "ConfigProductCreatedEvent": {
                        dbProvider.createConfigProduct(event);
                        break;
                    }
                    case "ConfigProductUpdatedEvent": {
                        dbProvider.updateConfigProduct(event);
                        break;
                    }
                    case "ConfigProductDeletedEvent": {
                        dbProvider.deleteConfigProduct(event);
                        break;
                    }
                    case "ConfigProductVersionCreatedEvent": {
                        dbProvider.createConfigProductVersion(event);
                        break;
                    }
                    case "ConfigProductVersionUpdatedEvent": {
                        dbProvider.updateConfigProductVersion(event);
                        break;
                    }
                    case "ConfigProductVersionDeletedEvent": {
                        dbProvider.deleteConfigProductVersion(event);
                        break;
                    }
                    case "AppCreatedEvent": {
                        dbProvider.createApp(event);
                        break;
                    }
                    case "AppUpdatedEvent": {
                        dbProvider.updateApp(event);
                        break;
                    }
                    case "AppDeletedEvent": {
                        dbProvider.deleteApp(event);
                        break;
                    }
                    case "ClientCreatedEvent": {
                        dbProvider.createClient(event);
                        break;
                    }
                    case "ClientUpdatedEvent": {
                        dbProvider.updateClient(event);
                        break;
                    }
                    case "ClientDeletedEvent": {
                        dbProvider.deleteClient(event);
                        break;
                    }
                    case "RefTableCreatedEvent": {
                        dbProvider.createRefTable(event);
                        break;
                    }
                    case "RefTableUpdatedEvent": {
                        dbProvider.updateRefTable(event);
                        break;
                    }
                    case "RefTableDeletedEvent": {
                        dbProvider.deleteRefTable(event);
                        break;
                    }
                    case "RefValueCreatedEvent": {
                        dbProvider.createRefValue(event);
                        break;
                    }
                    case "RefValueUpdatedEvent": {
                        dbProvider.updateRefValue(event);
                        break;
                    }
                    case "RefValueDeletedEvent": {
                        dbProvider.deleteRefValue(event);
                        break;
                    }
                    case "RefLocaleCreatedEvent": {
                        dbProvider.createRefLocale(event);
                        break;
                    }
                    case "RefLocaleUpdatedEvent": {
                        dbProvider.updateRefLocale(event);
                        break;
                    }
                    case "RefLocaleDeletedEvent": {
                        dbProvider.deleteRefLocale(event);
                        break;
                    }
                    case "RefRelationTypeCreatedEvent": {
                        dbProvider.createRefRelationType(event);
                        break;
                    }
                    case "RefRelationTypeUpdatedEvent": {
                        dbProvider.updateRefRelationType(event);
                        break;
                    }
                    case "RefRelationTypeDeletedEvent": {
                        dbProvider.deleteRefRelationType(event);
                        break;
                    }
                    case "RefRelationCreatedEvent": {
                        dbProvider.createRefRelation(event);
                        break;
                    }
                    case "RefRelationUpdatedEvent": {
                        dbProvider.updateRefRelation(event);
                        break;
                    }
                    case "RefRelationDeletedEvent": {
                        dbProvider.deleteRefRelation(event);
                        break;
                    }
                    default: {
                        logger.error("Unhandled event type '{}': {}", (Object)eventType, (Object)event);
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.error("Exception:", (Throwable)e);
            }
        }

        public void close() {
            if (logger.isInfoEnabled()) {
                logger.info("Closing processor...");
            }
        }
    }
}

