/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.user.query;

import com.networknt.config.Config;
import com.networknt.kafka.common.KafkaStreamsConfig;
import com.networknt.kafka.streams.LightStreams;
import com.networknt.utility.ByteUtil;
import java.util.Map;
import java.util.Properties;
import net.lightapi.portal.PortalConfig;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyQueryMetadata;
import org.apache.kafka.streams.StoreQueryParameters;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.errors.StreamsUncaughtExceptionHandler;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonceQueryStreams
implements LightStreams {
    private static final Logger logger = LoggerFactory.getLogger(NonceQueryStreams.class);
    static final KafkaStreamsConfig streamsConfig = (KafkaStreamsConfig)Config.getInstance().getJsonObjectConfig("kafka-streams", KafkaStreamsConfig.class);
    static final PortalConfig portalConfig = (PortalConfig)Config.getInstance().getJsonObjectConfig("portal", PortalConfig.class);
    private static final String nonce = "user-nonce-store";
    KafkaStreams nonceStreams;

    public NonceQueryStreams() {
        logger.info("NonceQueryStreams is created");
    }

    public ReadOnlyKeyValueStore<String, Long> getUserNonceStore() {
        QueryableStoreType queryableStoreType = QueryableStoreTypes.keyValueStore();
        StoreQueryParameters sqp = StoreQueryParameters.fromNameAndType((String)nonce, (QueryableStoreType)queryableStoreType);
        return (ReadOnlyKeyValueStore)this.nonceStreams.store(sqp);
    }

    public KeyQueryMetadata getUserNonceStreamsMetadata(String email) {
        return this.nonceStreams.queryMetadataForKey(nonce, (Object)email, Serdes.String().serializer());
    }

    private void startNonceStreams(String ip, int port) {
        StreamsBuilder builder = new StreamsBuilder();
        StoreBuilder keyValueNonceStoreBuilder = Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.persistentKeyValueStore((String)nonce), (Serde)Serdes.String(), (Serde)Serdes.Long());
        builder.addStateStore(keyValueNonceStoreBuilder);
        builder.stream(portalConfig.getNonceTopic()).process(new ProcessorSupplier(this){

            public Processor get() {
                return new NonceEventProcessor();
            }
        }, new String[]{nonce});
        Topology topology = builder.build();
        Properties streamsProps = new Properties();
        streamsProps.putAll((Map<?, ?>)streamsConfig.getProperties());
        streamsProps.put("default.key.serde", Serdes.ByteArray().getClass());
        streamsProps.put("default.value.serde", Serdes.ByteArray().getClass());
        streamsProps.put("application.id", portalConfig.getNonceApplicationId());
        streamsProps.put("application.server", ip + ":" + port);
        this.nonceStreams = new KafkaStreams(topology, streamsProps);
        this.nonceStreams.setUncaughtExceptionHandler(ex -> {
            logger.error("Kafka-Streams uncaught exception occurred. Stream will be replaced with new thread", ex);
            return StreamsUncaughtExceptionHandler.StreamThreadExceptionResponse.REPLACE_THREAD;
        });
        if (streamsConfig.isCleanUp()) {
            this.nonceStreams.cleanUp();
        }
        this.nonceStreams.start();
    }

    public void start(String ip, int port) {
        if (logger.isDebugEnabled()) {
            logger.debug("NonceStreams is starting...");
        }
        this.startNonceStreams(ip, port);
    }

    public void close() {
        if (logger.isDebugEnabled()) {
            logger.debug("NonceStreams is closing...");
        }
        this.nonceStreams.close();
    }

    public static class NonceEventProcessor
    extends AbstractProcessor<byte[], byte[]> {
        private ProcessorContext pc;
        private KeyValueStore<String, Long> nonceStore;

        public void init(ProcessorContext pc) {
            this.pc = pc;
            this.nonceStore = (KeyValueStore)pc.getStateStore(NonceQueryStreams.nonce);
            if (logger.isInfoEnabled()) {
                logger.info("Processor initialized");
            }
        }

        public void process(byte[] key, byte[] value) {
            this.nonceStore.put((Object)new String(key), (Object)ByteUtil.bytesToLong((byte[])value));
        }

        public void close() {
            if (logger.isInfoEnabled()) {
                logger.info("Closing processor...");
            }
        }
    }
}

