
package net.lightapi.portal.user.query.handler;

import com.networknt.monad.Result;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static net.lightapi.portal.user.query.UserQueryStreams.dbProvider;

/**
 * This endpoint will be called from the user-command to check if the userId exists in the system when creating
 * a new user. It queries the userId from the user_t table and return the user object. This endpoint is protected
 * as we don't want to reveal user's email to others.
 *
 * There are three situations: one is that the same user to query the user from the userId. The second one is an
 * admin or a host admin user doing the query in the admin page of the portal. The third one is that a peer to
 * query the user from a userId with client credential token for service to service call.
 *
 * @author Steve Hu
 */
@ServiceHandler(id="lightapi.net/user/queryUserById/0.1.0")
public class QueryUserById implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(QueryUserById.class);

    static final String USER_NOT_FOUND_BY_ID = "ERR11609";

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = {}", input);
        Map<String, Object> map = (Map<String, Object>)input;
        String userId = (String)map.get("userId");
        if(logger.isTraceEnabled()) logger.trace("userId = {}", userId);
        // TODO FGA implementation for three scenarios.
        Result<String> result = dbProvider.queryUserById(userId);
        if(result != null && result.isSuccess()) {
            return NioUtils.toByteBuffer(result.getResult());
        } else {
            return NioUtils.toByteBuffer(getStatus(exchange, USER_NOT_FOUND_BY_ID, userId));
        }
    }
}
