
package net.lightapi.portal.user.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * List all users by hostId. This is an endpoint that is used for the portal view users page with
 * pagination and search capability. The user list is sorted by the user's last name.
 */
@ServiceHandler(id="lightapi.net/user/listUserByHostId/0.1.0")
public class ListUserByHostId implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(ListUserByHostId.class);
    public static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = {}", input);
        Map<String, Object> map = (Map<String, Object>)input;
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");
        String hostId = (String)map.get("hostId");
        String email = (String)map.get("email");
        if(StringUtils.isEmpty(email)) email = null;
        String language = (String)map.get("language");
        if(StringUtils.isEmpty(language)) language = null;
        String userType = (String)map.get("userType");
        if(StringUtils.isEmpty(userType)) userType = null;
        String entityId = (String)map.get("entityId");
        if(StringUtils.isEmpty(entityId)) entityId = null;
        String referralId = (String)map.get("referralId");
        if(StringUtils.isEmpty(referralId)) referralId = null;
        String managerId = (String)map.get("managerId");
        if(StringUtils.isEmpty(managerId)) managerId = null;
        String firstName = (String)map.get("firstName");
        if(StringUtils.isEmpty(firstName)) firstName = null;
        String lastName = (String)map.get("lastName");
        if(StringUtils.isEmpty(lastName)) lastName = null;
        String phoneNumber = (String)map.get("phoneNumber");
        if(StringUtils.isEmpty(phoneNumber)) phoneNumber = null;
        String gender = (String)map.get("gender");
        if(StringUtils.isEmpty(gender)) gender = null;
        String birthday = (String)map.get("birthday");
        if(StringUtils.isEmpty(birthday)) birthday = null;
        String country = (String)map.get("country");
        if(StringUtils.isEmpty(country)) country = null;
        String province = (String)map.get("province");
        if(StringUtils.isEmpty(province)) province = null;
        String city = (String)map.get("city");
        if(StringUtils.isEmpty(city)) city = null;
        String address = (String)map.get("address");
        if(StringUtils.isEmpty(address)) address = null;
        String postCode = (String)map.get("postCode");
        if(StringUtils.isEmpty(postCode)) postCode = null;
        Boolean verified = (Boolean)map.get("verified");
        Boolean locked = (Boolean)map.get("locked");
        if(logger.isTraceEnabled()) logger.trace("offset = {} limit = {} hostId = {} email = {} language = {} userType = {} entityId = {} " +
                        "referralId = {} managerId = {} firstName = {} lastName = {} phoneNumber = {}  gender = {} birthday = {} country = {} " +
                        "province = {} city = {} address = {} postCode = {} verified = {} locked = {}", offset, limit, hostId, email, language,
                userType, entityId, referralId, managerId, firstName, lastName, phoneNumber, gender, birthday, country, province, city, address,
                postCode, verified, locked);

        Result<String> result = dbProvider.queryUserByHostId(offset, limit, hostId, email, language, userType, entityId,
                referralId, managerId, firstName, lastName, phoneNumber, gender, birthday, country, province, city,
                address, postCode, verified, locked);
        if(result.isFailure()) {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "user", hostId));
        } else {
            String users = result.getResult();
            if(logger.isTraceEnabled()) logger.trace("users = {}", users);
            return NioUtils.toByteBuffer(users);
        }
    }
}
