package net.lightapi.portal.user.query.handler;

import com.networknt.config.JsonMapper;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.monad.Result;
import com.networknt.server.ServerConfig;
import com.networknt.utility.NetUtils;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.HybridQueryClient;
import net.lightapi.portal.user.query.UserQueryStartup;
import org.apache.kafka.streams.KeyQueryMetadata;
import org.apache.kafka.streams.state.HostInfo;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/user/getRolesByEmail/0.1.0")
public class GetRolesByEmail implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetRolesByEmail.class);

    static final String USER_NOT_FOUND_BY_EMAIL = "ERR11607";
    static final String USER_QUERY_DENIED = "ERR11618";

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = " + input);
        /*
        Map<String, String> map = (Map<String, String>)input;
        String email = map.get("email");
        Map<String, Object> auditInfo = exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
        // if security is not enabled, then allow everyone to access for dev env.
        if(auditInfo != null) {
            String userId = (String)auditInfo.get("user_id");
            if(userId != null) {
                // authorization code token make sure the userId is match or roles contains admin
                String roles = (String)auditInfo.get("roles");
                if(!email.equals(userId) && roles != null && !roles.contains("admin")) {
                    // email and jwt userId is not matched and roles doesn't contain admin
                    return NioUtils.toByteBuffer(getStatus(exchange, USER_QUERY_DENIED, email, userId));
                }
            }
            // userId is null indicates it is a client credentials token from another service.
        }
        // email shouldn't be null as the schema validation is done.
        ReadOnlyKeyValueStore<String, String> keyValueStore = UserQueryStartup.userStreams.getUserEmailStore();
        String data = (String) UserQueryStartup.userStreams.getKafkaValueByKey(keyValueStore, email);
        if(data == null) {
            // lookup other instance
            KeyQueryMetadata metadata = UserQueryStartup.userStreams.getUserEmailStreamsMetadata(email);
            HostInfo hostInfo = metadata.activeHost();
            if(logger.isDebugEnabled()) logger.debug("found address in another instance " + hostInfo.host() + ":" + hostInfo.port());
            // Don't call if the host and port is the same as the current instance. Dead loop will occur.
            String url = "https://" + hostInfo.host() + ":" + hostInfo.port();
            if(NetUtils.getLocalAddressByDatagram().equals(hostInfo.host()) && ServerConfig.getInstance().getHttpsPort() == hostInfo.port()) {
                // TODO remove this block if we never seen the following error.
                logger.error("******Kafka returns the same instance!");
                return NioUtils.toByteBuffer(getStatus(exchange, USER_NOT_FOUND_BY_EMAIL, email));
            } else {
                Result<String> resultUser = HybridQueryClient.getUserByEmail(exchange, url, email);
                if(resultUser.isSuccess()) {
                    data = resultUser.getResult();
                }
            }
        }
        if(data == null) return NioUtils.toByteBuffer(getStatus(exchange, USER_NOT_FOUND_BY_EMAIL, email));
        Map<String, Object> userMap = JsonMapper.string2Map(data);
        String roles = (String)userMap.get("roles");
        Map<String, Object> resultMap = new HashMap<>();
        resultMap.put("roles", roles);
        return NioUtils.toByteBuffer(JsonMapper.toJson(resultMap));

         */
        return null;
    }
}
