
package net.lightapi.portal.user.query.handler;

import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.user.query.UserQueryStartup;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/user/getReference/0.1.0")
public class GetReference implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetReference.class);

    static final String REFERENCE_NOT_FOUND = "ERR11634";

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = " + input);
        Map<String, String> map = (Map<String, String>)input;
        String name = map.get("name");
        String lang = map.get("lang");
        if(lang == null) lang = "en";
        /*
        ReadOnlyKeyValueStore<String, String> keyValueStore = UserQueryStartup.userStreams.getReferenceStore();
        String data = (String) UserQueryStartup.userStreams.getKafkaValueByKey(keyValueStore, name + "|" + lang);
        if(data != null) {
            return NioUtils.toByteBuffer(data);
        }
        return NioUtils.toByteBuffer(getStatus(exchange, REFERENCE_NOT_FOUND, name, lang));

         */
        return null;
    }
}
