
package net.lightapi.portal.user.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.server.ServerConfig;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NetUtils;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.HybridQueryClient;
import net.lightapi.portal.db.PortalDbProvider;
import net.lightapi.portal.user.query.UserQueryStartup;
import org.apache.kafka.streams.KeyQueryMetadata;
import org.apache.kafka.streams.state.HostInfo;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/user/getNotification/0.1.0")
public class GetNotification implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetNotification.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = " + input);
        Map<String, Object> map = (Map<String, Object>)input;
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");
        String hostId = (String)map.get("hostId");

        String userId = (String)map.get("userId");
        if(StringUtils.isBlank(userId)) userId = null;
        Long nonce = null;
        String s = (String)map.get("nonce");
        if(!StringUtils.isBlank(s)) {
            try {
                nonce = Long.parseLong(s);
            } catch (NumberFormatException e) {
                if(logger.isTraceEnabled()) logger.trace("nonce {} is not a number", s);
            }
        }
        String eventClass = (String)map.get("eventClass");
        if(StringUtils.isBlank(eventClass)) eventClass = null;
        Boolean successFlag = null;
        String processFlag = (String)map.get("processFlag");
        if(!StringUtils.isBlank(processFlag) && processFlag.equalsIgnoreCase("Y")) {
            successFlag = true;
        }
        java.sql.Timestamp processTs = null;
        String processTime = (String)map.get("processTime");
        if(!StringUtils.isBlank(processTime)) processTs = java.sql.Timestamp.valueOf(processTime);
        String eventJson = (String)map.get("eventJson");
        if(StringUtils.isBlank(eventJson)) eventJson = null;
        String error = (String)map.get("error");
        if(StringUtils.isBlank(error)) error = null;

        if(logger.isTraceEnabled())
            logger.trace("offset = {} limit = {} hostId = {} userId = {} nonce = {} eventClass = {} successFlag = {} processTime = {} eventJson = {} error = {}",
                    offset, limit, hostId, userId, nonce, eventClass, successFlag, processTime, eventJson, error);
        Result<String> result = dbProvider.queryNotification(offset, limit, hostId, userId, nonce, eventClass, successFlag, processTs, eventJson, error);
        if(result.isFailure()) {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "notification", hostId));
        } else {
            return NioUtils.toByteBuffer(result.getResult());
        }
    }
}
