
package net.lightapi.portal.user.query.handler;

import com.networknt.config.JsonMapper;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.monad.Result;
import com.networknt.server.ServerConfig;
import com.networknt.utility.NetUtils;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.HybridQueryClient;
import net.lightapi.portal.user.query.UserQueryStartup;
import org.apache.kafka.streams.KeyQueryMetadata;
import org.apache.kafka.streams.state.HostInfo;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/user/getCustomerOrder/0.1.0")
public class GetCustomerOrder implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetCustomerOrder.class);

    static final String ORDER_NOT_FOUND_BY_EMAIL = "ERR11633";
    static final String PERMISSION_DENIED = "ERR11620";

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = " + input);
        /*
        Map<String, Object> map = (Map<String, Object>)input;
        String email = (String)map.get("email");
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");
        Map<String, Object> auditInfo = exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
        // if security is not enabled, then allow everyone to access for dev env.
        if(auditInfo != null) {
            String userId = (String)auditInfo.get("user_id");
            if(userId != null) {
                // authorization code token make sure the userId is match or roles contains admin
                String roles = (String)auditInfo.get("roles");
                if(!email.equals(userId) && roles != null && !roles.contains("admin")) {
                    // email and jwt userId is not matched and roles doesn't contain admin
                    return NioUtils.toByteBuffer(getStatus(exchange, PERMISSION_DENIED, roles));
                }
            }
            // userId is null indicates it is a client credentials token from another service.
        }

        ReadOnlyKeyValueStore<String, String> keyValueStore = UserQueryStartup.userStreams.getCustomerOrderStore();
        String data = (String) UserQueryStartup.userStreams.getKafkaValueByKey(keyValueStore, email);
        if(data == null) {
            // lookup the instance with the order partition keyed by the email.
            KeyQueryMetadata metadata = UserQueryStartup.userStreams.getCustomerOrderStreamsMetadata(email);
            HostInfo hostInfo = metadata.activeHost();
            if(logger.isDebugEnabled()) logger.debug("found address in another instance " + hostInfo.host() + ":" + hostInfo.port());
            // Don't call if the host and port is the same as the current instance. Dead loop will occur.
            String url = "https://" + hostInfo.host() + ":" + hostInfo.port();
            if(NetUtils.getLocalAddressByDatagram().equals(hostInfo.host()) && ServerConfig.getInstance().getHttpsPort() == hostInfo.port()) {
                // TODO remove this block if we never seen the following error.
                logger.error("******Kafka returns the same instance!");
                return NioUtils.toByteBuffer(getStatus(exchange, ORDER_NOT_FOUND_BY_EMAIL, email));
            } else {
                Result<String> resultOrder = HybridQueryClient.getCustomerOrderByEmail(exchange, url, email, offset, limit);
                if(resultOrder.isSuccess()) {
                    data = resultOrder.getResult();
                    // offset and limit are applied to data already.
                    return NioUtils.toByteBuffer(data);
                } else {
                    return NioUtils.toByteBuffer(getStatus(exchange, resultOrder.getError()));
                }
            }
        } else {
            // get the order entries with pagination
            List<Map<String, Object>> orders = JsonMapper.string2List(data);
            List<Map<String, Object>> list = new ArrayList<>();
            if(orders != null && orders.size() >= offset) {
                int max = orders.size() > offset + limit ? offset + limit : orders.size();
                for(int i = offset; i < max; i++) {
                    list.add(orders.get(i));
                }
            }
            Map<String, Object> result = new HashMap<>();
            result.put("orders", list);
            result.put("total", orders == null ? 0 : orders.size());
            return NioUtils.toByteBuffer(JsonMapper.toJson(result));
        }
         */
        return null;
    }
}
