
package net.lightapi.portal.user.query.handler;

import com.braintreegateway.BraintreeGateway;
import com.braintreegateway.ClientTokenRequest;
import com.braintreegateway.Environment;
import com.networknt.client.oauth.ClientCredentialsRequest;
import com.networknt.client.oauth.OauthHelper;
import com.networknt.client.oauth.TokenRequest;
import com.networknt.client.oauth.TokenResponse;
import com.networknt.config.JsonMapper;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.monad.Result;
import com.networknt.server.ServerConfig;
import com.networknt.utility.NetUtils;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.HybridQueryClient;
import net.lightapi.portal.user.query.UserQueryStartup;
import org.apache.kafka.streams.KeyQueryMetadata;
import org.apache.kafka.streams.state.HostInfo;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * This is an endpoint to get Braintree client token to start the drop-in interface on the UI.
 * Condition to meet to get the client token:
 * merchant userId
 * customer email? Need the customer to login and get it from the token.
 * sandbox?
 *
 * @author Steve Hu
 */
@ServiceHandler(id="lightapi.net/user/getClientToken/0.1.0")
public class GetClientToken implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetClientToken.class);

    static final String USER_NOT_FOUND_BY_ID = "ERR11609";
    static final String PAYMENT_NOT_FOUND_BY_EMAIL = "ERR11632";

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = " + input);
        /*
        Map<String, Object> map = (Map<String, Object>)input;
        String merchantUserId = (String)map.get("userId");
        String merchantId = (String)map.get("merchantId");
        Map<String, Object> auditInfo = exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
        // if security is not enabled, then allow everyone to access for dev env.
        String customerEmail = null;
        if(auditInfo != null) {
            customerEmail = (String)auditInfo.get("user_id");
        }

        String email = null;
        ReadOnlyKeyValueStore<String, String> keyValueStore = UserQueryStartup.userStreams.getUserIdStore();
        email = (String) UserQueryStartup.userStreams.getKafkaValueByKey(keyValueStore, merchantUserId);
        if(email == null) {
            return NioUtils.toByteBuffer(getStatus(exchange, USER_NOT_FOUND_BY_ID, merchantUserId));
        }

        keyValueStore = UserQueryStartup.userStreams.getUserPaymentStore();
        String data = (String) UserQueryStartup.userStreams.getKafkaValueByKey(keyValueStore, email);
        if(data == null) {
            // lookup the instance with the payment partition keyed by the email.
            KeyQueryMetadata metadata = UserQueryStartup.userStreams.getPaymentStreamsMetadata(email);
            HostInfo hostInfo = metadata.activeHost();
            if(logger.isDebugEnabled()) logger.debug("found address in another instance " + hostInfo.host() + ":" + hostInfo.port());
            // Don't call if the host and port is the same as the current instance. Dead loop will occur.
            String url = "https://" + hostInfo.host() + ":" + hostInfo.port();
            if(NetUtils.getLocalAddressByDatagram().equals(hostInfo.host()) && ServerConfig.getInstance().getHttpsPort() == hostInfo.port()) {
                // TODO remove this block if we never seen the following error.
                logger.error("******Kafka returns the same instance!");
                return NioUtils.toByteBuffer(getStatus(exchange, PAYMENT_NOT_FOUND_BY_EMAIL, email));
            } else {
                TokenRequest tokenRequest = new ClientCredentialsRequest();
                Result<TokenResponse> resultJwt = OauthHelper.getTokenResult(tokenRequest);
                if(resultJwt.isFailure()) {
                    return NioUtils.toByteBuffer(getStatus(exchange, resultJwt.getError()));
                }
                Result<String> resultPayment = HybridQueryClient.getPaymentByEmail(url, email, resultJwt.getResult().getAccessToken());
                if(resultPayment.isSuccess()) {
                    data = resultPayment.getResult();
                }
            }
        }
        // at this moment, return 404 if data is still null.
        if(data == null) return NioUtils.toByteBuffer(getStatus(exchange, PAYMENT_NOT_FOUND_BY_EMAIL, email));

        // get the Braintree entry with sandbox flag in case there are two entries.
        List<Map<String, Object>> payments = JsonMapper.string2List(data);
        for (Map<String, Object> payment : payments) {
            if ("Braintree".equals(payment.get("method")) && payment.get("merchantId").equals(merchantId)) {
                BraintreeGateway gateway = new BraintreeGateway(
                        Environment.SANDBOX,
                        merchantId,
                        (String) payment.get("publicKey"),
                        (String) payment.get("privateKey")
                );
                ClientTokenRequest clientTokenRequest = new ClientTokenRequest();
                String clientToken = gateway.clientToken().generate(clientTokenRequest);
                Map<String, String> clientTokenMap = new HashMap<String, String>();
                clientTokenMap.put("clientToken", clientToken);
                return NioUtils.toByteBuffer(JsonMapper.toJson(clientTokenMap));
            }
        }
        return NioUtils.toByteBuffer(getStatus(exchange, PAYMENT_NOT_FOUND_BY_EMAIL, email));
         */
        return null;
    }
}
