/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.user.query.handler;

import com.networknt.httpstring.AttachmentConstants;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.NioUtils;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.util.Map;
import net.lightapi.portal.user.query.UserQueryStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/user/queryUserByWallet/0.1.0")
public class QueryUserByWallet
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(QueryUserByWallet.class);
    static final String EMAIL_NOT_FOUND_BY_WALLET = "ERR11630";
    static final String WALLET_QUERY_DENIED = "ERR11629";

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        Result result;
        String roles;
        if (logger.isTraceEnabled()) {
            logger.trace("input = " + String.valueOf(input));
        }
        Map map = (Map)input;
        String wallet = (String)map.get("taijiWallet");
        String email = null;
        boolean isAdmin = false;
        Map auditInfo = (Map)exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
        if (auditInfo != null && (email = (String)auditInfo.get("user_id")) != null && (roles = (String)auditInfo.get("roles")) != null && roles.contains("admin")) {
            isAdmin = true;
        }
        if ((result = UserQueryStreams.dbProvider.queryUserById(wallet)) != null && result.isSuccess()) {
            if (email != null && !email.equals(result.getResult()) && !isAdmin) {
                return NioUtils.toByteBuffer((String)this.getStatus(exchange, WALLET_QUERY_DENIED, new Object[]{wallet, email}));
            }
            return NioUtils.toByteBuffer((String)((String)result.getResult()));
        }
        return NioUtils.toByteBuffer((String)this.getStatus(exchange, EMAIL_NOT_FOUND_BY_WALLET, new Object[]{wallet}));
    }
}

