/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.user.query.handler;

import com.networknt.httpstring.AttachmentConstants;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.NioUtils;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.util.Map;
import net.lightapi.portal.user.query.UserQueryStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/user/queryUserByEmail/0.1.0")
public class QueryUserByEmail
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(QueryUserByEmail.class);
    static final String USER_NOT_FOUND_BY_EMAIL = "ERR11607";
    static final String USER_QUERY_DENIED = "ERR11618";

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        Result result;
        String userId;
        Map auditInfo;
        if (logger.isTraceEnabled()) {
            logger.trace("input = {}", input);
        }
        Map map = (Map)input;
        String email = (String)map.get("email");
        if (logger.isTraceEnabled()) {
            logger.trace("email = {}", (Object)email);
        }
        if ((auditInfo = (Map)exchange.getAttachment(AttachmentConstants.AUDIT_INFO)) != null && (userId = (String)auditInfo.get("user_id")) != null) {
            String roles = (String)auditInfo.get("roles");
            if (!email.equals(userId) && roles != null && !roles.contains("admin")) {
                return NioUtils.toByteBuffer((String)this.getStatus(exchange, USER_QUERY_DENIED, new Object[]{email, userId}));
            }
        }
        if ((result = UserQueryStreams.dbProvider.queryUserByEmail(email)) != null && result.isSuccess()) {
            return NioUtils.toByteBuffer((String)((String)result.getResult()));
        }
        return NioUtils.toByteBuffer((String)this.getStatus(exchange, USER_NOT_FOUND_BY_EMAIL, new Object[]{email}));
    }
}

