/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.user.query.handler;

import com.networknt.config.JsonMapper;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.HashUtil;
import com.networknt.utility.NioUtils;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;
import net.lightapi.portal.user.query.UserQueryStreams;

@ServiceHandler(id="lightapi.net/user/loginUser/0.1.0")
public class LoginUser
implements HybridHandler {
    private static final String ERROR_VALIDATE_PASSWORD = "ERR11616";
    private static final String USER_NOT_FOUND_BY_EMAIL = "ERR11607";
    private static final String WRONG_LOGIN_PASSWORD = "ERR11612";
    private static final String EMAIL_NOT_CONFIRMED = "ERR11610";

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        Map map = (Map)input;
        String email = (String)map.get("email");
        String password = (String)map.get("password");
        Result result = UserQueryStreams.dbProvider.loginUserByEmail(email);
        if (result.isFailure()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, USER_NOT_FOUND_BY_EMAIL, new Object[]{email}));
        }
        if (logger.isTraceEnabled()) {
            logger.trace("user = {}", result.getResult());
        }
        return NioUtils.toByteBuffer((String)this.validatePassword(exchange, password, (String)result.getResult(), email));
    }

    private String validatePassword(HttpServerExchange exchange, String inputPassword, String userResult, String email) {
        try {
            Map userMap = JsonMapper.string2Map((String)userResult);
            boolean valid = HashUtil.validatePassword((char[])inputPassword.toCharArray(), (String)((String)userMap.get("password")));
            if (valid) {
                boolean verified = (Boolean)userMap.get("verified");
                if (verified) {
                    return userResult;
                }
                return this.getStatus(exchange, EMAIL_NOT_CONFIRMED, new Object[]{email});
            }
            return this.getStatus(exchange, WRONG_LOGIN_PASSWORD, new Object[]{email});
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            return this.getStatus(exchange, ERROR_VALIDATE_PASSWORD, new Object[]{email});
        }
    }
}

