/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.user.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.util.Map;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/user/listUserByHostId/0.1.0")
public class ListUserByHostId
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(ListUserByHostId.class);
    public static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider)SingletonServiceFactory.getBean(DbProvider.class);

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        Result result;
        String postCode;
        String address;
        String city;
        String province;
        String country;
        String birthday;
        String gender;
        String phoneNumber;
        String lastName;
        String firstName;
        String managerId;
        String referralId;
        String entityId;
        String userType;
        String language;
        if (logger.isTraceEnabled()) {
            logger.trace("input = {}", input);
        }
        Map map = (Map)input;
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");
        String hostId = (String)map.get("hostId");
        String email = (String)map.get("email");
        if (StringUtils.isEmpty((CharSequence)email)) {
            email = null;
        }
        if (StringUtils.isEmpty((CharSequence)(language = (String)map.get("language")))) {
            language = null;
        }
        if (StringUtils.isEmpty((CharSequence)(userType = (String)map.get("userType")))) {
            userType = null;
        }
        if (StringUtils.isEmpty((CharSequence)(entityId = (String)map.get("entityId")))) {
            entityId = null;
        }
        if (StringUtils.isEmpty((CharSequence)(referralId = (String)map.get("referralId")))) {
            referralId = null;
        }
        if (StringUtils.isEmpty((CharSequence)(managerId = (String)map.get("managerId")))) {
            managerId = null;
        }
        if (StringUtils.isEmpty((CharSequence)(firstName = (String)map.get("firstName")))) {
            firstName = null;
        }
        if (StringUtils.isEmpty((CharSequence)(lastName = (String)map.get("lastName")))) {
            lastName = null;
        }
        if (StringUtils.isEmpty((CharSequence)(phoneNumber = (String)map.get("phoneNumber")))) {
            phoneNumber = null;
        }
        if (StringUtils.isEmpty((CharSequence)(gender = (String)map.get("gender")))) {
            gender = null;
        }
        if (StringUtils.isEmpty((CharSequence)(birthday = (String)map.get("birthday")))) {
            birthday = null;
        }
        if (StringUtils.isEmpty((CharSequence)(country = (String)map.get("country")))) {
            country = null;
        }
        if (StringUtils.isEmpty((CharSequence)(province = (String)map.get("province")))) {
            province = null;
        }
        if (StringUtils.isEmpty((CharSequence)(city = (String)map.get("city")))) {
            city = null;
        }
        if (StringUtils.isEmpty((CharSequence)(address = (String)map.get("address")))) {
            address = null;
        }
        if (StringUtils.isEmpty((CharSequence)(postCode = (String)map.get("postCode")))) {
            postCode = null;
        }
        Boolean verified = (Boolean)map.get("verified");
        Boolean locked = (Boolean)map.get("locked");
        if (logger.isTraceEnabled()) {
            logger.trace("offset = {} limit = {} hostId = {} email = {} language = {} userType = {} entityId = {} referralId = {} managerId = {} firstName = {} lastName = {} phoneNumber = {}  gender = {} birthday = {} country = {} province = {} city = {} address = {} postCode = {} verified = {} locked = {}", new Object[]{offset, limit, hostId, email, language, userType, entityId, referralId, managerId, firstName, lastName, phoneNumber, gender, birthday, country, province, city, address, postCode, verified, locked});
        }
        if ((result = dbProvider.queryUserByHostId(offset, limit, hostId, email, language, userType, entityId, referralId, managerId, firstName, lastName, phoneNumber, gender, birthday, country, province, city, address, postCode, verified, locked)).isFailure()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, OBJECT_NOT_FOUND, new Object[]{"user", hostId}));
        }
        String users = (String)result.getResult();
        if (logger.isTraceEnabled()) {
            logger.trace("users = {}", (Object)users);
        }
        return NioUtils.toByteBuffer((String)users);
    }
}

