/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.user.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.Map;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/user/getNotification/0.1.0")
public class GetNotification
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetNotification.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider)SingletonServiceFactory.getBean(DbProvider.class);

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        Result result;
        String error;
        String eventJson;
        String eventClass;
        Long nonce;
        String userId;
        String hostId;
        int limit;
        int offset;
        Map map;
        block12: {
            if (logger.isTraceEnabled()) {
                logger.trace("input = " + String.valueOf(input));
            }
            map = (Map)input;
            offset = (Integer)map.get("offset");
            limit = (Integer)map.get("limit");
            hostId = (String)map.get("hostId");
            userId = (String)map.get("userId");
            if (StringUtils.isBlank((CharSequence)userId)) {
                userId = null;
            }
            nonce = null;
            String s = (String)map.get("nonce");
            if (!StringUtils.isBlank((CharSequence)s)) {
                try {
                    nonce = Long.parseLong(s);
                }
                catch (NumberFormatException e) {
                    if (!logger.isTraceEnabled()) break block12;
                    logger.trace("nonce {} is not a number", (Object)s);
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)(eventClass = (String)map.get("eventClass")))) {
            eventClass = null;
        }
        Boolean successFlag = null;
        String processFlag = (String)map.get("processFlag");
        if (!StringUtils.isBlank((CharSequence)processFlag) && processFlag.equalsIgnoreCase("Y")) {
            successFlag = true;
        }
        Timestamp processTs = null;
        String processTime = (String)map.get("processTime");
        if (!StringUtils.isBlank((CharSequence)processTime)) {
            processTs = Timestamp.valueOf(processTime);
        }
        if (StringUtils.isBlank((CharSequence)(eventJson = (String)map.get("eventJson")))) {
            eventJson = null;
        }
        if (StringUtils.isBlank((CharSequence)(error = (String)map.get("error")))) {
            error = null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("offset = {} limit = {} hostId = {} userId = {} nonce = {} eventClass = {} successFlag = {} processTime = {} eventJson = {} error = {}", new Object[]{offset, limit, hostId, userId, nonce, eventClass, successFlag, processTime, eventJson, error});
        }
        if ((result = dbProvider.queryNotification(offset, limit, hostId, userId, nonce, eventClass, successFlag, processTs, eventJson, error)).isFailure()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, OBJECT_NOT_FOUND, new Object[]{"notification", hostId}));
        }
        return NioUtils.toByteBuffer((String)((String)result.getResult()));
    }
}

