/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.user.query;

import com.networknt.server.ServerConfig;
import com.networknt.server.StartupHookProvider;
import com.networknt.utility.NetUtils;
import net.lightapi.portal.user.query.NonceQueryStreams;
import net.lightapi.portal.user.query.NotificationStreams;
import net.lightapi.portal.user.query.UserQueryStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserQueryStartup
implements StartupHookProvider {
    private static final Logger logger = LoggerFactory.getLogger(UserQueryStartup.class);
    public static UserQueryStreams userStreams = null;
    public static NonceQueryStreams nonceStreams = null;
    public static NotificationStreams notificationStreams = null;

    public void onStartup() {
        logger.info("UserQueryStartup onStartup begins.");
        int port = ServerConfig.getInstance().getHttpsPort();
        String ip = NetUtils.getLocalAddressByDatagram();
        logger.info("ip = " + ip + " port = " + port);
        userStreams = new UserQueryStreams();
        userStreams.start(ip, port);
        nonceStreams = new NonceQueryStreams();
        nonceStreams.start(ip, port);
        notificationStreams = new NotificationStreams();
        notificationStreams.start(ip, port);
        logger.info("UserQueryStartup onStartup ends.");
    }
}

