
package net.lightapi.portal.user.query.handler;

import com.networknt.httpstring.AttachmentConstants;
import com.networknt.monad.Result;
import com.networknt.server.ServerConfig;
import com.networknt.utility.NetUtils;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.HybridQueryClient;
import net.lightapi.portal.user.query.UserQueryStartup;
import org.apache.kafka.streams.KeyQueryMetadata;
import org.apache.kafka.streams.state.HostInfo;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * This is an endpoint to return a list of private messages received by the user. The key is the email
 * and all messages should have been sent to the partition with the key as the email.
 *
 * @author Steve Hu
 */
@ServiceHandler(id="lightapi.net/user/getPrivateMessage/0.1.0")
public class GetPrivateMessage implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetPrivateMessage.class);

    static final String PRIVATE_MESSAGE_NOT_FOUND = "ERR11627";
    static final String USER_QUERY_DENIED = "ERR11618";

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = " + input);
        /*
        Map<String, Object> map = (Map<String, Object>)input;
        String email = (String)map.get("email");
        Map<String, Object> auditInfo = exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
        // if security is not enabled, then allow everyone to access for dev env.
        if(auditInfo != null) {
            String userId = (String)auditInfo.get("user_id");
            if(userId != null) {
                // authorization code token make sure the userId is match or roles contains admin
                String roles = (String)auditInfo.get("roles");
                if(!email.equals(userId) && roles != null && !roles.contains("admin")) {
                    // email and jwt userId is not matched and roles doesn't contain admin
                    return NioUtils.toByteBuffer(getStatus(exchange, USER_QUERY_DENIED, email, userId));
                }
            }
            // userId is null indicates it is a client credentials token from another service.
        }
        ReadOnlyKeyValueStore<String, String> keyValueStore = UserQueryStartup.userStreams.getUserMessageStore();
        String data = (String) UserQueryStartup.userStreams.getKafkaValueByKey(keyValueStore, email);
        if(data != null) {
            return NioUtils.toByteBuffer(data);
        } else {
            // lookup the instance that is responsible for the partition with key as email
            KeyQueryMetadata metadata = UserQueryStartup.userStreams.getUserMessageStreamsMetadata(email);
            HostInfo hostInfo = metadata.activeHost();
            if(logger.isDebugEnabled()) logger.debug("found address in another instance " + hostInfo.host() + ":" + hostInfo.port());
            String url = "https://" + hostInfo.host() + ":" + hostInfo.port();
            if(NetUtils.getLocalAddressByDatagram().equals(hostInfo.host()) && ServerConfig.getInstance().getHttpsPort() == hostInfo.port()) {
                // TODO remove this block if we never seen the following error.
                logger.error("******Kafka returns the same instance!");
                return NioUtils.toByteBuffer(getStatus(exchange, PRIVATE_MESSAGE_NOT_FOUND, email));
            } else {
                Result<String> resultMessage = HybridQueryClient.getMessageByEmail(exchange, url, email);
                if(resultMessage.isSuccess()) {
                    return NioUtils.toByteBuffer(resultMessage.getResult());
                }
            }
            return NioUtils.toByteBuffer(getStatus(exchange, PRIVATE_MESSAGE_NOT_FOUND, email));

        }

         */
        return null;
    }
}
