/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.service.query.handler;

import com.networknt.config.JsonMapper;
import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/service/getServicePermission/0.1.0")
public class GetServicePermission
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetServicePermission.class);
    public static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider)SingletonServiceFactory.getBean(DbProvider.class);

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        Result result;
        if (logger.isTraceEnabled()) {
            logger.trace("input = {}", input);
        }
        Map map = (Map)input;
        String hostId = (String)map.get("hostId");
        String apiId = (String)map.get("apiId");
        String apiVersion = (String)map.get("apiVersion");
        if (logger.isTraceEnabled()) {
            logger.trace("hostId = {} apiId = {} apiVersion = {}", new Object[]{hostId, apiId, apiVersion});
        }
        if ((result = dbProvider.queryServicePermission(hostId, apiId, apiVersion)).isFailure()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, OBJECT_NOT_FOUND, new Object[]{"service permission", "hostId: " + hostId + " apiId: " + apiId + " apiVersion: " + apiVersion}));
        }
        String servicePermission = (String)result.getResult();
        if (logger.isTraceEnabled()) {
            logger.trace("servicePermission = {}", (Object)servicePermission);
        }
        List<Map<String, Object>> output = GetServicePermission.transformJsonList(JsonMapper.string2List((String)servicePermission));
        Result filterResult = dbProvider.queryServiceFilter(hostId, apiId, apiVersion);
        if (filterResult.isFailure()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, OBJECT_NOT_FOUND, new Object[]{"service filter", "hostId: " + hostId + " apiId: " + apiId + " apiVersion: " + apiVersion}));
        }
        List filters = (List)filterResult.getResult();
        if (logger.isTraceEnabled()) {
            logger.trace("filters = {}", (Object)filters);
        }
        List<Map<String, Object>> enrichedOutput = GetServicePermission.enrichWithFilters(output, filters);
        String outputJson = JsonMapper.toJson(enrichedOutput);
        if (logger.isTraceEnabled()) {
            logger.trace("outputJson = {}", (Object)outputJson);
        }
        return NioUtils.toByteBuffer((String)outputJson);
    }

    public static List<Map<String, Object>> transformJsonList(List<Map<String, Object>> inputList) {
        return inputList.stream().map(GetServicePermission::transformMap).filter(transformedMap -> !transformedMap.isEmpty()).collect(Collectors.toList());
    }

    private static Map<String, Object> transformMap(Map<String, Object> inputMap) {
        HashMap<String, Object> transformedMap = new HashMap<String, Object>(inputMap);
        for (String key : List.of("roles", "positions", "groups", "users")) {
            if (!transformedMap.containsKey(key)) continue;
            String transformedValue = GetServicePermission.transformListMapToString(transformedMap.get(key));
            if (!transformedValue.isEmpty()) {
                transformedMap.put(key, transformedValue);
                continue;
            }
            transformedMap.remove(key);
        }
        if (transformedMap.containsKey("attributes")) {
            List<Map<String, Object>> transformedAttributes = GetServicePermission.transformAttributes((List)transformedMap.get("attributes"));
            if (!transformedAttributes.isEmpty()) {
                transformedMap.put("attributes", transformedAttributes);
            } else {
                transformedMap.remove("attributes");
            }
        }
        return transformedMap;
    }

    private static String transformListMapToString(Object listOrString) {
        if (listOrString instanceof String) {
            return (String)listOrString;
        }
        if (listOrString instanceof List) {
            List listOfMaps = (List)listOrString;
            return listOfMaps.stream().filter(Objects::nonNull).map(map -> map.values().stream().filter(Objects::nonNull).findFirst().orElse("")).filter(value -> !value.toString().isEmpty()).map(Object::toString).collect(Collectors.joining(" "));
        }
        return "";
    }

    private static List<Map<String, Object>> transformAttributes(List<Map<String, String>> attributesList) {
        ArrayList<Map<String, Object>> attributes = new ArrayList<Map<String, Object>>();
        if (attributesList != null) {
            for (Map<String, String> attribute : attributesList) {
                HashMap<String, String> attributeMap = new HashMap<String, String>();
                if (attribute != null && attribute.get("attribute_id") != null && attribute.get("attribute_value") != null) {
                    attributeMap.put(attribute.get("attribute_id"), attribute.get("attribute_value"));
                }
                attributes.add(attributeMap);
            }
        }
        return attributes;
    }

    private static List<Map<String, Object>> enrichWithFilters(List<Map<String, Object>> output, List<String> filters) {
        Map<String, Object> filtersMap = GetServicePermission.transformFilter(filters);
        for (Map<String, Object> endpointMap : output) {
            String endpoint = (String)endpointMap.get("endpoint");
            Map map = (Map)filtersMap.get(endpoint);
            if (map == null) continue;
            endpointMap.putAll(map);
        }
        return output;
    }

    public static Map<String, Object> transformFilter(List<String> input) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap endpointFilters = new HashMap();
        HashMap rowMap = new HashMap();
        HashMap colMap = new HashMap();
        endpointFilters.put("row", rowMap);
        endpointFilters.put("col", colMap);
        for (String jsonStr : input) {
            try {
                Map parsedMap = JsonMapper.string2Map((String)jsonStr);
                parsedMap.forEach((type, typeData) -> {
                    if (typeData instanceof List) {
                        List dataList = (List)typeData;
                        String endpoint = null;
                        for (Map item : dataList) {
                            endpoint = (String)item.get("endpoint");
                            if (type.equals("role_row")) {
                                GetServicePermission.processRoleRow(rowMap, item);
                                continue;
                            }
                            if (!type.equals("role_col")) continue;
                            GetServicePermission.processRoleCol(colMap, item);
                        }
                        if (endpoint != null) {
                            result.put(endpoint, endpointFilters);
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static void processRoleRow(Map<String, Object> rowMap, Map<String, Object> item) {
        String roleId = (String)item.get("roleId");
        Map roleMap = (Map)rowMap.computeIfAbsent("role", k -> new HashMap());
        List roleFilters = (List)roleMap.computeIfAbsent(roleId, k -> new ArrayList());
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("colName", (String)item.get("colName"));
        filter.put("operator", (String)item.get("operator"));
        filter.put("colValue", (String)item.get("colValue"));
        roleFilters.add(filter);
    }

    private static void processRoleCol(Map<String, Object> colMap, Map<String, Object> item) {
        String roleId = (String)item.get("roleId");
        Map roleMap = (Map)colMap.computeIfAbsent("role", k -> new HashMap());
        roleMap.put(roleId, item.get("columns"));
    }
}

