/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.service.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.util.Map;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/service/getServiceEndpoint/0.1.0")
public class GetServiceEndpoint
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetServiceEndpoint.class);
    public static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider)SingletonServiceFactory.getBean(DbProvider.class);

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        Result result;
        String desc;
        String path;
        String method;
        if (logger.isTraceEnabled()) {
            logger.trace("input = {}", input);
        }
        Map map = (Map)input;
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");
        String hostId = (String)map.get("hostId");
        String apiVersionId = (String)map.get("apiVersionId");
        String apiId = (String)map.get("apiId");
        String apiVersion = (String)map.get("apiVersion");
        String endpoint = (String)map.get("endpoint");
        if (StringUtils.isEmpty((CharSequence)endpoint)) {
            endpoint = null;
        }
        if (StringUtils.isEmpty((CharSequence)(method = (String)map.get("method")))) {
            method = null;
        }
        if (StringUtils.isEmpty((CharSequence)(path = (String)map.get("path")))) {
            path = null;
        }
        if (StringUtils.isEmpty((CharSequence)(desc = (String)map.get("desc")))) {
            desc = null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("hostId = {} apiVersionId = {} apiId = {} apiVersion = {} endpoint = {} method = {} path = {} desc = {}", new Object[]{hostId, apiVersionId, apiId, apiVersion, endpoint, method, path, desc});
        }
        if ((result = dbProvider.queryServiceEndpoint(offset, limit, hostId, apiVersionId, apiId, apiVersion, endpoint, method, path, desc)).isFailure()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, OBJECT_NOT_FOUND, new Object[]{"api endpoint", "hostId: " + hostId + " apiId: " + apiId + " apiVersion: " + apiVersion}));
        }
        String serviceEndpoint = (String)result.getResult();
        if (logger.isTraceEnabled()) {
            logger.trace("serviceEndpoint = {}", (Object)serviceEndpoint);
        }
        return NioUtils.toByteBuffer((String)serviceEndpoint);
    }
}

