/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.service.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.util.Map;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/service/getService/0.1.0")
public class GetService
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetService.class);
    public static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider)SingletonServiceFactory.getBean(DbProvider.class);

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        Result result;
        String apiStatus;
        String apiTags;
        String gitRepo;
        String capability;
        String platform;
        String lob;
        String businessGroup;
        String region;
        String deliveryOwner;
        String operationOwner;
        String apiDesc;
        String apiName;
        if (logger.isTraceEnabled()) {
            logger.trace("input = {}", input);
        }
        Map map = (Map)input;
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");
        String hostId = (String)map.get("hostId");
        String apiId = (String)map.get("apiId");
        if (StringUtils.isBlank((CharSequence)apiId)) {
            apiId = null;
        }
        if (StringUtils.isBlank((CharSequence)(apiName = (String)map.get("apiName")))) {
            apiName = null;
        }
        if (StringUtils.isBlank((CharSequence)(apiDesc = (String)map.get("apiDesc")))) {
            apiDesc = null;
        }
        if (StringUtils.isBlank((CharSequence)(operationOwner = (String)map.get("operationOwner")))) {
            operationOwner = null;
        }
        if (StringUtils.isBlank((CharSequence)(deliveryOwner = (String)map.get("deliveryOwner")))) {
            deliveryOwner = null;
        }
        if (StringUtils.isBlank((CharSequence)(region = (String)map.get("region")))) {
            region = null;
        }
        if (StringUtils.isBlank((CharSequence)(businessGroup = (String)map.get("businessGroup")))) {
            businessGroup = null;
        }
        if (StringUtils.isBlank((CharSequence)(lob = (String)map.get("lob")))) {
            lob = null;
        }
        if (StringUtils.isBlank((CharSequence)(platform = (String)map.get("platform")))) {
            platform = null;
        }
        if (StringUtils.isBlank((CharSequence)(capability = (String)map.get("capability")))) {
            capability = null;
        }
        if (StringUtils.isBlank((CharSequence)(gitRepo = (String)map.get("gitRepo")))) {
            gitRepo = null;
        }
        if (StringUtils.isBlank((CharSequence)(apiTags = (String)map.get("apiTags")))) {
            apiTags = null;
        }
        if (StringUtils.isBlank((CharSequence)(apiStatus = (String)map.get("apiStatus")))) {
            apiStatus = null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("offset = {} limit = {} hostId = {} apiId = {} apiName = {} apiDesc = {} operationOwner = {} deliveryOwner = {} region = {} businessGroup = {} lob = {} platform = {} capability = {} gitRepo = {} apiTags = {} apiStatus = {}", new Object[]{offset, limit, hostId, apiId, apiName, apiDesc, operationOwner, deliveryOwner, region, businessGroup, lob, platform, capability, gitRepo, apiTags, apiStatus});
        }
        if ((result = dbProvider.queryService(offset, limit, hostId, apiId, apiName, apiDesc, operationOwner, deliveryOwner, region, businessGroup, lob, platform, capability, gitRepo, apiTags, apiStatus)).isFailure()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, OBJECT_NOT_FOUND, new Object[]{"api_t", hostId}));
        }
        String services = (String)result.getResult();
        if (logger.isTraceEnabled()) {
            logger.trace("services = {}", (Object)services);
        }
        return NioUtils.toByteBuffer((String)services);
    }
}

