/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.service.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.util.Map;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/service/getEndpointScope/0.1.0")
public class GetEndpointScope
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetEndpointScope.class);
    public static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider)SingletonServiceFactory.getBean(DbProvider.class);

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        Result result;
        if (logger.isTraceEnabled()) {
            logger.trace("input = {}", input);
        }
        Map map = (Map)input;
        String hostId = (String)map.get("hostId");
        String endpointId = (String)map.get("endpointId");
        if (logger.isTraceEnabled()) {
            logger.trace("hostId = {} endpointId = {}", (Object)hostId, (Object)endpointId);
        }
        if ((result = dbProvider.queryEndpointScope(hostId, endpointId)).isFailure()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, OBJECT_NOT_FOUND, new Object[]{"endpoint scope", "hostId: " + hostId + " endpointId: " + endpointId}));
        }
        String endpointScope = (String)result.getResult();
        if (logger.isTraceEnabled()) {
            logger.trace("endpointScope = {}", (Object)endpointScope);
        }
        return NioUtils.toByteBuffer((String)endpointScope);
    }
}

