
package net.lightapi.portal.service.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Get all service keys (service ids plus optional build numbers) belong to one host from
 * a global host key value store. By clicking each serviceId and buildNumber combination on
 * the UI, one can see the details of the registered service.
 *
 * @author Steve Hu
*/
@ServiceHandler(id="lightapi.net/service/getServiceVersion/0.1.0")
public class GetServiceVersion implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetServiceVersion.class);
    public static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = {}", input);
        Map<String, Object> map = (Map<String, Object>)input;
        String hostId = (String)map.get("hostId");
        String apiId = (String)map.get("apiId");
        if(logger.isTraceEnabled())
            logger.trace("hostId = {} apiId = {}", hostId, apiId);
        Result<String> result = dbProvider.queryServiceVersion(hostId, apiId);
        if(result.isFailure()) {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "api_version_t", "hostId: " + hostId + " apiId: " + apiId));
        } else {
            return NioUtils.toByteBuffer(result.getResult());
        }
    }
}
