
package net.lightapi.portal.service.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * This is called by the light-4j server during startup with the rule-loader startup hook to load the rules for
 * the service.
*/
@ServiceHandler(id="lightapi.net/service/getServiceRule/0.1.0")
public class GetServiceRule implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetServiceRule.class);
    public static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = {}", input);
        Map<String, Object> map = (Map<String, Object>)input;
        String hostId = (String)map.get("hostId");
        String apiId = (String)map.get("apiId");
        String apiVersion = (String)map.get("apiVersion");
        if(logger.isTraceEnabled())
            logger.trace("hostId = {} apiId = {} apiVersion = {}", hostId, apiId, apiVersion);
        Result<String> result = dbProvider.queryServiceRule(hostId, apiId, apiVersion);
        if(result.isFailure()) {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "service rule", "hostId: " + hostId + " apiId: " + apiId + " apiVersion: " + apiVersion));
        } else {
            String serviceRule = result.getResult();
            if(logger.isTraceEnabled()) logger.trace("serviceRule = {}", serviceRule);
            return NioUtils.toByteBuffer(serviceRule);
        }
    }
}
