
package net.lightapi.portal.service.query.handler;

import com.networknt.config.JsonMapper;
import com.networknt.monad.Result;
import com.networknt.server.ServerConfig;
import com.networknt.utility.NetUtils;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.HybridQueryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * This is the endpoint that returns a list of roles in a map to populate the UI dropdown by a serviceId.
 * It is similar to the getServiceById but retrieving only the roles from the service object instead of
 * the entire object.
 *
 * @author Steve Hu
*/
@ServiceHandler(id="lightapi.net/service/getServiceRoleById/0.1.0")
public class GetServiceRoleById implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetServiceRoleById.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = " + input);
        Map<String, Object> map = (Map<String, Object>)input;
        String serviceId = (String)map.get("serviceId");
        /*
        ReadOnlyKeyValueStore<String, String> keyValueStore = MarketQueryStartup.streams.getServiceStore();
        String data = (String) MarketQueryStartup.streams.getKafkaValueByKey(keyValueStore, serviceId);
        if(data != null) {
            Map<String, Object> serviceMap = JsonMapper.string2Map(data);
            List<String> roles = (List)serviceMap.get("roles");
            List<Map<String, String>> resultList = new ArrayList<>();
            if(roles != null) {
                for(String role : roles) {
                    Map<String, String> kvMap = new HashMap<>();
                    kvMap.put(role, role);
                    resultList.add(kvMap);
                }
            }
            return NioUtils.toByteBuffer(JsonMapper.toJson(resultList));
        } else {
            KeyQueryMetadata metadata = MarketQueryStartup.streams.getClientStreamsMetadata(serviceId);
            HostInfo hostInfo = metadata.activeHost();
            if(logger.isDebugEnabled()) logger.debug("found address in another instance " + hostInfo.host() + ":" + hostInfo.port());
            String url = "https://" + hostInfo.host() + ":" + hostInfo.port();
            if(NetUtils.getLocalAddressByDatagram().equals(hostInfo.host()) && ServerConfig.getInstance().getHttpsPort() == hostInfo.port()) {
                // TODO remove this block if we never seen the following error.
                logger.error("******Kafka returns the same instance!");
                return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "service", serviceId));
            } else {
                Result<String> resultStatus = HybridQueryClient.getServiceRoleById(exchange, url, serviceId);
                if (resultStatus.isSuccess()) {
                    return NioUtils.toByteBuffer(resultStatus.getResult());
                }
            }
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "service", serviceId));
        }
        */
        return NioUtils.toByteBuffer("");
    }
}
