
package net.lightapi.portal.service.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Get service endpoint by hostId, apiId and apiVersion. It is used by the portal-view to render the service endpoint
 * page from the service detail page. The service endpoint page will display the endpoint information and allow the
 * user to view the scopes associated with the endpoint and also check the request access and response filter FGA rules.
 *
 * @author Steve Hu
*/
@ServiceHandler(id="lightapi.net/service/getServiceEndpoint/0.1.0")
public class GetServiceEndpoint implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetServiceEndpoint.class);
    public static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = {}", input);
        Map<String, Object> map = (Map<String, Object>)input;
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");
        String hostId = (String)map.get("hostId");
        String apiVersionId = (String)map.get("apiVersionId");
        String apiId = (String)map.get("apiId");
        String apiVersion = (String)map.get("apiVersion");


        String endpoint = (String)map.get("endpoint");
        if(StringUtils.isEmpty(endpoint)) endpoint = null;
        String method = (String)map.get("method");
        if(StringUtils.isEmpty(method)) method = null;
        String path = (String)map.get("path");
        if(StringUtils.isEmpty(path)) path = null;
        String desc = (String)map.get("desc");
        if(StringUtils.isEmpty(desc)) desc = null;

        if(logger.isTraceEnabled())
            logger.trace("hostId = {} apiVersionId = {} apiId = {} apiVersion = {} endpoint = {} method = {} path = {} desc = {}", hostId, apiVersionId, apiId, apiVersion, endpoint, method, path, desc);
        Result<String> result = dbProvider.queryServiceEndpoint(offset, limit, hostId, apiVersionId, apiId, apiVersion, endpoint, method, path, desc);
        if(result.isFailure()) {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "api endpoint", "hostId: " + hostId + " apiId: " + apiId + " apiVersion: " + apiVersion));
        } else {
            String serviceEndpoint = result.getResult();
            if(logger.isTraceEnabled()) logger.trace("serviceEndpoint = {}", serviceEndpoint);
            return NioUtils.toByteBuffer(serviceEndpoint);
        }
    }
}
