
package net.lightapi.portal.service.query.handler;

import com.networknt.monad.Result;
import com.networknt.server.ServerConfig;
import com.networknt.utility.NetUtils;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.HybridQueryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * get service by service id
*/
@ServiceHandler(id="lightapi.net/service/getServiceById/0.1.0")
public class GetServiceById implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetServiceById.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = " + input);
        Map<String, Object> map = (Map<String, Object>)input;
        String serviceId = (String)map.get("serviceId");
        /*
        ReadOnlyKeyValueStore<String, String> keyValueStore = MarketQueryStartup.streams.getServiceStore();
        String data = (String) MarketQueryStartup.streams.getKafkaValueByKey(keyValueStore, serviceId);
        if(data != null) {
            return NioUtils.toByteBuffer(data);
        } else {
            KeyQueryMetadata metadata = MarketQueryStartup.streams.getClientStreamsMetadata(serviceId);
            HostInfo hostInfo = metadata.activeHost();
            if(logger.isDebugEnabled()) logger.debug("found address in another instance " + hostInfo.host() + ":" + hostInfo.port());
            String url = "https://" + hostInfo.host() + ":" + hostInfo.port();
            if(NetUtils.getLocalAddressByDatagram().equals(hostInfo.host()) && ServerConfig.getInstance().getHttpsPort() == hostInfo.port()) {
                // TODO remove this block if we never seen the following error.
                logger.error("******Kafka returns the same instance!");
                return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "service", serviceId));
            } else {
                Result<String> resultStatus = HybridQueryClient.getServiceById(exchange, url, serviceId);
                if (resultStatus.isSuccess()) {
                    return NioUtils.toByteBuffer(resultStatus.getResult());
                }
            }
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "service", serviceId));
        }
        */
        return NioUtils.toByteBuffer("");
    }
}
